/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.factory;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.decorator.ExtensionsAwareProcessorDecorator;
import ro.isdc.wro.model.resource.processor.decorator.ProcessorDecorator;
import ro.isdc.wro.model.resource.processor.factory.ProcessorsFactory;
import ro.isdc.wro.model.resource.processor.support.ProcessorProvider;
import ro.isdc.wro.model.resource.support.AbstractConfigurableMultipleStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurableProcessorsFactory
implements ProcessorsFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurableProcessorsFactory.class);
    public static final String PARAM_PRE_PROCESSORS = "preProcessors";
    public static final String PARAM_POST_PROCESSORS = "postProcessors";
    private Map<String, ResourcePreProcessor> preProcessorsMap;
    private Map<String, ResourcePostProcessor> postProcessorsMap;
    private Properties properties;
    private final AbstractConfigurableMultipleStrategy<ResourcePreProcessor, ProcessorProvider> configurablePreProcessors = new AbstractConfigurableMultipleStrategy<ResourcePreProcessor, ProcessorProvider>(){

        @Override
        protected String getStrategyKey() {
            return ConfigurableProcessorsFactory.PARAM_PRE_PROCESSORS;
        }

        @Override
        protected void overrideDefaultStrategyMap(Map<String, ResourcePreProcessor> map) {
            this.copyAll(ConfigurableProcessorsFactory.this.getPreProcessorsMap(), map);
        }

        @Override
        protected Map<String, ResourcePreProcessor> getStrategies(ProcessorProvider provider) {
            return provider.providePreProcessors();
        }

        @Override
        protected ResourcePreProcessor getStrategyForAlias(String alias) {
            ResourcePreProcessor processor = (ResourcePreProcessor)super.getStrategyForAlias(alias);
            if (processor == null) {
                boolean hasExtension;
                String extension = FilenameUtils.getExtension((String)alias);
                boolean bl = hasExtension = !StringUtils.isEmpty((CharSequence)extension);
                if (hasExtension) {
                    String processorName = FilenameUtils.getBaseName((String)alias);
                    LOG.debug("processorName: {}", (Object)processorName);
                    processor = (ResourcePreProcessor)super.getStrategyForAlias(processorName);
                    if (processor != null) {
                        LOG.debug("adding Extension: {}", (Object)extension);
                        processor = ExtensionsAwareProcessorDecorator.decorate(processor).addExtension(extension);
                    }
                }
            }
            return processor;
        }

        @Override
        protected Properties newProperties() {
            return ConfigurableProcessorsFactory.this.getProperties();
        }
    };
    private final AbstractConfigurableMultipleStrategy<ResourcePostProcessor, ProcessorProvider> configurablePostProcessors = new AbstractConfigurableMultipleStrategy<ResourcePostProcessor, ProcessorProvider>(){

        @Override
        protected String getStrategyKey() {
            return ConfigurableProcessorsFactory.PARAM_POST_PROCESSORS;
        }

        @Override
        protected void overrideDefaultStrategyMap(Map<String, ResourcePostProcessor> map) {
            this.copyAll(ConfigurableProcessorsFactory.this.getPostProcessorsMap(), map);
        }

        @Override
        protected Map<String, ResourcePostProcessor> getStrategies(ProcessorProvider provider) {
            return provider.providePostProcessors();
        }

        @Override
        protected ResourcePostProcessor getStrategyForAlias(String alias) {
            ResourcePostProcessor processor = (ResourcePostProcessor)super.getStrategyForAlias(alias);
            if (processor == null) {
                boolean hasExtension;
                String extension = FilenameUtils.getExtension((String)alias);
                boolean bl = hasExtension = !StringUtils.isEmpty((CharSequence)extension);
                if (hasExtension) {
                    String processorName = FilenameUtils.getBaseName((String)alias);
                    LOG.debug("processorName: {}", (Object)processorName);
                    processor = (ResourcePostProcessor)super.getStrategyForAlias(processorName);
                    if (processor != null) {
                        LOG.debug("adding Extension: {}", (Object)extension);
                        processor = ExtensionsAwareProcessorDecorator.decorate(new ProcessorDecorator(processor)).addExtension(extension);
                    }
                }
            }
            return processor;
        }

        @Override
        protected Properties newProperties() {
            return ConfigurableProcessorsFactory.this.getProperties();
        }
    };

    protected Properties newProperties() {
        return new Properties();
    }

    @Override
    public final Collection<ResourcePreProcessor> getPreProcessors() {
        return this.configurablePreProcessors.getConfiguredStrategies();
    }

    @Override
    public final Collection<ResourcePostProcessor> getPostProcessors() {
        return this.configurablePostProcessors.getConfiguredStrategies();
    }

    public ConfigurableProcessorsFactory setPreProcessorsMap(Map<String, ResourcePreProcessor> map) {
        Validate.notNull(map);
        this.preProcessorsMap = map;
        return this;
    }

    public ConfigurableProcessorsFactory setPostProcessorsMap(Map<String, ResourcePostProcessor> map) {
        Validate.notNull(map);
        this.postProcessorsMap = map;
        return this;
    }

    public ConfigurableProcessorsFactory setProperties(Properties properties) {
        Validate.notNull((Object)properties);
        this.properties = properties;
        return this;
    }

    protected Map<String, ResourcePreProcessor> newPreProcessorsMap() {
        return new HashMap<String, ResourcePreProcessor>();
    }

    protected Map<String, ResourcePostProcessor> newPostProcessorsMap() {
        return new HashMap<String, ResourcePostProcessor>();
    }

    private Properties getProperties() {
        if (this.properties == null) {
            this.properties = this.newProperties();
        }
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ResourcePreProcessor> getPreProcessorsMap() {
        if (this.preProcessorsMap == null) {
            ConfigurableProcessorsFactory configurableProcessorsFactory = this;
            synchronized (configurableProcessorsFactory) {
                if (this.preProcessorsMap == null) {
                    this.preProcessorsMap = this.newPreProcessorsMap();
                }
            }
        }
        return this.preProcessorsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ResourcePostProcessor> getPostProcessorsMap() {
        if (this.postProcessorsMap == null) {
            ConfigurableProcessorsFactory configurableProcessorsFactory = this;
            synchronized (configurableProcessorsFactory) {
                if (this.postProcessorsMap == null) {
                    this.postProcessorsMap = this.newPostProcessorsMap();
                }
            }
        }
        return this.postProcessorsMap;
    }

    Collection<ResourcePreProcessor> getAvailablePreProcessors() {
        return this.configurablePreProcessors.getAvailableStrategies();
    }

    Collection<ResourcePostProcessor> getAvailablePostProcessors() {
        return this.configurablePostProcessors.getAvailableStrategies();
    }
}

