/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.locator.support;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.http.support.RedirectedStreamServletResponseWrapper;
import ro.isdc.wro.model.resource.locator.UriLocator;
import ro.isdc.wro.model.resource.locator.UrlUriLocator;
import ro.isdc.wro.util.WroUtil;

public class DispatcherStreamLocator {
    private static final Logger LOG = LoggerFactory.getLogger(DispatcherStreamLocator.class);

    public InputStream getInputStream(HttpServletRequest request, HttpServletResponse response, String location) throws IOException {
        Validate.notNull((Object)request);
        Validate.notNull((Object)response);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        boolean warnOnEmptyStream = false;
        Context originalContext = Context.get();
        try {
            RequestDispatcher dispatcher = request.getRequestDispatcher(location);
            if (dispatcher != null) {
                ServletRequest servletRequest = this.getWrappedServletRequest(request, location);
                RedirectedStreamServletResponseWrapper servletResponse = new RedirectedStreamServletResponseWrapper(os, response);
                LOG.debug("dispatching request to location: " + location);
                dispatcher.include(servletRequest, (ServletResponse)servletResponse);
                warnOnEmptyStream = true;
                servletResponse.getWriter().flush();
                os.close();
            }
            if (os.size() == 0) {
                String servletContextPath = request.getRequestURL().toString().replace(request.getServletPath(), "");
                String absolutePath = servletContextPath + location;
                InputStream inputStream = this.createExternalResourceLocator().locate(absolutePath);
                return inputStream;
            }
        }
        catch (Exception e) {
            LOG.debug("[FAIL] Error while dispatching the request for location {}", (Object)location);
            throw new IOException("Error while dispatching the request for location " + location);
        }
        finally {
            if (warnOnEmptyStream && os.size() == 0) {
                LOG.warn("Wrong or empty resource with location: {}", (Object)location);
            }
            if (!Context.isContextSet()) {
                Context.set(originalContext);
            }
        }
        return new ByteArrayInputStream(os.toByteArray());
    }

    UriLocator createExternalResourceLocator() {
        return new UrlUriLocator(){

            public boolean isEnableWildcards() {
                return false;
            }
        };
    }

    private ServletRequest getWrappedServletRequest(HttpServletRequest request, final String location) {
        HttpServletRequestWrapper wrappedRequest = new HttpServletRequestWrapper(request){

            public String getRequestURI() {
                return this.getContextPath() + location;
            }

            public String getPathInfo() {
                return WroUtil.getPathInfoFromLocation((HttpServletRequest)this, location);
            }

            public String getServletPath() {
                return WroUtil.getServletPathFromLocation((HttpServletRequest)this, location);
            }
        };
        return wrappedRequest;
    }
}

