/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.locator.factory;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.resource.locator.UriLocator;
import ro.isdc.wro.model.resource.locator.factory.DefaultUriLocatorFactory;
import ro.isdc.wro.model.resource.locator.factory.SimpleUriLocatorFactory;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.locator.support.LocatorProvider;
import ro.isdc.wro.model.resource.support.AbstractConfigurableMultipleStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurableLocatorFactory
extends AbstractConfigurableMultipleStrategy<UriLocator, LocatorProvider>
implements UriLocatorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurableLocatorFactory.class);
    public static final String PARAM_URI_LOCATORS = "uriLocators";
    private final UriLocatorFactory locatorFactory = this.newUriLocatorFactory();

    @Override
    protected String getStrategyKey() {
        return PARAM_URI_LOCATORS;
    }

    @Override
    protected Map<String, UriLocator> getStrategies(LocatorProvider provider) {
        return provider.provideLocators();
    }

    @Override
    public InputStream locate(String uri) throws IOException {
        return this.locatorFactory.locate(uri);
    }

    private UriLocatorFactory newUriLocatorFactory() {
        SimpleUriLocatorFactory factory = new SimpleUriLocatorFactory();
        List locators = this.getConfiguredStrategies();
        for (UriLocator locator : locators) {
            factory.addUriLocator(locator);
        }
        if (locators.isEmpty()) {
            LOG.info("No locators configured. Using Default locator factory.");
            return new DefaultUriLocatorFactory();
        }
        return factory;
    }

    @Override
    public UriLocator getInstance(String uri) {
        return this.locatorFactory.getInstance(uri);
    }

    @Override
    protected Class<LocatorProvider> getProviderClass() {
        return LocatorProvider.class;
    }
}

