/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.group.processor;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import ro.isdc.wro.cache.CacheEntry;
import ro.isdc.wro.cache.CacheStrategy;
import ro.isdc.wro.cache.ContentHashEntry;
import ro.isdc.wro.cache.DefaultSynchronizedCacheStrategyDecorator;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.ReadOnlyContext;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.manager.WroManager;
import ro.isdc.wro.manager.callback.LifecycleCallbackRegistry;
import ro.isdc.wro.manager.factory.WroManagerFactory;
import ro.isdc.wro.model.factory.DefaultWroModelFactoryDecorator;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.group.GroupExtractor;
import ro.isdc.wro.model.group.processor.GroupsProcessor;
import ro.isdc.wro.model.group.processor.Injector;
import ro.isdc.wro.model.group.processor.PreProcessorExecutor;
import ro.isdc.wro.model.resource.locator.factory.InjectorAwareUriLocatorFactoryDecorator;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.processor.factory.ProcessorsFactory;
import ro.isdc.wro.model.resource.support.ResourceAuthorizationManager;
import ro.isdc.wro.model.resource.support.hash.HashStrategy;
import ro.isdc.wro.model.resource.support.naming.NamingStrategy;
import ro.isdc.wro.util.LazyInitializer;
import ro.isdc.wro.util.ObjectFactory;

public class InjectorBuilder {
    private final GroupsProcessor groupsProcessor = new GroupsProcessor();
    private final PreProcessorExecutor preProcessorExecutor = new PreProcessorExecutor();
    private Injector injector;
    private final Map<Class<?>, Object> map = new HashMap();
    private WroManagerFactory managerFactory;
    private final LazyInitializer<UriLocatorFactory> uriLocatorFactoryInitializer = new LazyInitializer<UriLocatorFactory>(){

        @Override
        protected UriLocatorFactory initialize() {
            WroManager manager = (WroManager)InjectorBuilder.this.managerFactory.create();
            InjectorAwareUriLocatorFactoryDecorator decorated = new InjectorAwareUriLocatorFactoryDecorator(manager.getUriLocatorFactory(), InjectorBuilder.this.injector);
            manager.setUriLocatorFactory(decorated);
            return decorated;
        }
    };
    private ResourceAuthorizationManager authorizationManager = new ResourceAuthorizationManager();
    private final LazyInitializer<WroModelFactory> modelFactoryInitializer = new LazyInitializer<WroModelFactory>(){

        @Override
        protected WroModelFactory initialize() {
            WroManager manager = (WroManager)InjectorBuilder.this.managerFactory.create();
            DefaultWroModelFactoryDecorator decorated = new DefaultWroModelFactoryDecorator(manager.getModelFactory(), manager.getModelTransformers());
            manager.setModelFactory(decorated);
            return decorated;
        }
    };
    private final LazyInitializer<CacheStrategy<CacheEntry, ContentHashEntry>> cacheStrategyInitializer = new LazyInitializer<CacheStrategy<CacheEntry, ContentHashEntry>>(){

        @Override
        protected CacheStrategy<CacheEntry, ContentHashEntry> initialize() {
            WroManager manager = (WroManager)InjectorBuilder.this.managerFactory.create();
            DefaultSynchronizedCacheStrategyDecorator decorated = new DefaultSynchronizedCacheStrategyDecorator(((WroManager)InjectorBuilder.this.managerFactory.create()).getCacheStrategy());
            manager.setCacheStrategy(decorated);
            return decorated;
        }
    };

    public InjectorBuilder() {
    }

    public static InjectorBuilder create(WroManagerFactory managerFactory) {
        Validate.notNull((Object)managerFactory);
        return new InjectorBuilder(managerFactory);
    }

    public InjectorBuilder(WroManagerFactory managerFactory) {
        Validate.notNull((Object)managerFactory);
        this.managerFactory = managerFactory;
    }

    private void initMap() {
        this.map.put(PreProcessorExecutor.class, new InjectorObjectFactory<PreProcessorExecutor>(){

            @Override
            public PreProcessorExecutor create() {
                InjectorBuilder.this.injector.inject(InjectorBuilder.this.preProcessorExecutor);
                return InjectorBuilder.this.preProcessorExecutor;
            }
        });
        this.map.put(GroupsProcessor.class, new InjectorObjectFactory<GroupsProcessor>(){

            @Override
            public GroupsProcessor create() {
                InjectorBuilder.this.injector.inject(InjectorBuilder.this.groupsProcessor);
                return InjectorBuilder.this.groupsProcessor;
            }
        });
        this.map.put(LifecycleCallbackRegistry.class, new InjectorObjectFactory<LifecycleCallbackRegistry>(){

            @Override
            public LifecycleCallbackRegistry create() {
                LifecycleCallbackRegistry callbackRegistry = ((WroManager)InjectorBuilder.this.managerFactory.create()).getCallbackRegistry();
                InjectorBuilder.this.injector.inject(callbackRegistry);
                return callbackRegistry;
            }
        });
        this.map.put(GroupExtractor.class, new InjectorObjectFactory<GroupExtractor>(){

            @Override
            public GroupExtractor create() {
                GroupExtractor groupExtractor = ((WroManager)InjectorBuilder.this.managerFactory.create()).getGroupExtractor();
                InjectorBuilder.this.injector.inject(groupExtractor);
                return groupExtractor;
            }
        });
        this.map.put(Injector.class, new InjectorObjectFactory<Injector>(){

            @Override
            public Injector create() {
                return InjectorBuilder.this.injector;
            }
        });
        this.map.put(UriLocatorFactory.class, new InjectorObjectFactory<UriLocatorFactory>(){

            @Override
            public UriLocatorFactory create() {
                return (UriLocatorFactory)InjectorBuilder.this.uriLocatorFactoryInitializer.get();
            }
        });
        this.map.put(ProcessorsFactory.class, new InjectorObjectFactory<ProcessorsFactory>(){

            @Override
            public ProcessorsFactory create() {
                return ((WroManager)InjectorBuilder.this.managerFactory.create()).getProcessorsFactory();
            }
        });
        this.map.put(WroModelFactory.class, new InjectorObjectFactory<WroModelFactory>(){

            @Override
            public WroModelFactory create() {
                WroModelFactory modelFactory = (WroModelFactory)InjectorBuilder.this.modelFactoryInitializer.get();
                InjectorBuilder.this.injector.inject(modelFactory);
                return modelFactory;
            }
        });
        this.map.put(NamingStrategy.class, new InjectorObjectFactory<NamingStrategy>(){

            @Override
            public NamingStrategy create() {
                NamingStrategy namingStrategy = ((WroManager)InjectorBuilder.this.managerFactory.create()).getNamingStrategy();
                InjectorBuilder.this.injector.inject(namingStrategy);
                return namingStrategy;
            }
        });
        this.map.put(ReadOnlyContext.class, this.createReadOnlyContextProxy());
        this.map.put(WroConfiguration.class, new InjectorObjectFactory<WroConfiguration>(){

            @Override
            public WroConfiguration create() {
                return Context.get().getConfig();
            }
        });
        this.map.put(CacheStrategy.class, new InjectorObjectFactory<CacheStrategy<CacheEntry, ContentHashEntry>>(){

            @Override
            public CacheStrategy<CacheEntry, ContentHashEntry> create() {
                CacheStrategy decorated = (CacheStrategy)InjectorBuilder.this.cacheStrategyInitializer.get();
                InjectorBuilder.this.injector.inject(decorated);
                return decorated;
            }
        });
        this.map.put(ResourceAuthorizationManager.class, new InjectorObjectFactory<ResourceAuthorizationManager>(){

            @Override
            public ResourceAuthorizationManager create() {
                return InjectorBuilder.this.authorizationManager;
            }
        });
        this.map.put(HashStrategy.class, new InjectorObjectFactory<HashStrategy>(){

            @Override
            public HashStrategy create() {
                return ((WroManager)InjectorBuilder.this.managerFactory.create()).getHashStrategy();
            }
        });
    }

    private ReadOnlyContext createReadOnlyContextProxy() {
        InvocationHandler handler = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return method.invoke((Object)Context.get(), args);
            }
        };
        ReadOnlyContext readOnlyContext = (ReadOnlyContext)Proxy.newProxyInstance(ReadOnlyContext.class.getClassLoader(), new Class[]{ReadOnlyContext.class}, handler);
        return readOnlyContext;
    }

    public Injector build() {
        this.initMap();
        this.injector = new Injector(Collections.unmodifiableMap(this.map));
        return this.injector;
    }

    public InjectorBuilder setResourceAuthorizationManager(ResourceAuthorizationManager authManager) {
        Validate.notNull((Object)authManager);
        this.authorizationManager = authManager;
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface InjectorObjectFactory<T>
    extends ObjectFactory<T> {
    }
}

