/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.group.processor;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.cache.CacheEntry;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.manager.callback.LifecycleCallbackRegistry;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.group.Group;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.group.processor.Injector;
import ro.isdc.wro.model.group.processor.PreProcessorExecutor;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.decorator.ExceptionHandlingProcessorDecorator;
import ro.isdc.wro.model.resource.processor.factory.ProcessorsFactory;
import ro.isdc.wro.model.resource.processor.support.ProcessorsUtils;
import ro.isdc.wro.util.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupsProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(GroupsProcessor.class);
    @Inject
    private LifecycleCallbackRegistry callbackRegistry;
    @Inject
    private ProcessorsFactory processorsFactory;
    @Inject
    private WroModelFactory modelFactory;
    @Inject
    private WroConfiguration config;
    @Inject
    private Injector injector;
    @Inject
    private transient PreProcessorExecutor preProcessorExecutor;

    public String process(CacheEntry cacheKey) {
        Validate.notNull((Object)cacheKey);
        try {
            LOG.debug("Starting processing group [{}] of type [{}] with minimized flag: " + cacheKey.isMinimize(), (Object)cacheKey.getGroupName(), (Object)cacheKey.getType());
            WroModel model = (WroModel)this.modelFactory.create();
            Group group = model.getGroupByName(cacheKey.getGroupName());
            Group filteredGroup = group.collectResourcesOfType(cacheKey.getType());
            if (filteredGroup.getResources().isEmpty()) {
                LOG.debug("No resources found in group: {} and resource type: {}", (Object)group.getName(), (Object)cacheKey.getType());
                if (!this.config.isIgnoreEmptyGroup()) {
                    throw new WroRuntimeException("No resources found in group: " + group.getName());
                }
            }
            String result = this.preProcessorExecutor.processAndMerge(filteredGroup.getResources(), cacheKey.isMinimize());
            String string = this.doPostProcess(result, cacheKey);
            return string;
        }
        catch (IOException e) {
            throw new WroRuntimeException("Exception while merging resources", e);
        }
        finally {
            this.callbackRegistry.onProcessingComplete();
        }
    }

    private String doPostProcess(String content, CacheEntry cacheEntry) throws IOException {
        Validate.notNull((Object)content);
        Collection<ResourcePostProcessor> allPostProcessors = this.processorsFactory.getPostProcessors();
        if (allPostProcessors.isEmpty() && this.processorsFactory.getPreProcessors().isEmpty()) {
            LOG.warn("No processors defined. Please, check if your configuration is correct.");
        }
        Collection<ResourcePostProcessor> processors = ProcessorsUtils.filterProcessorsToApply(cacheEntry.isMinimize(), cacheEntry.getType(), allPostProcessors);
        return this.applyPostProcessors(processors, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String applyPostProcessors(Collection<ResourcePostProcessor> processors, String content) throws IOException {
        LOG.debug("postProcessors: {}", processors);
        if (processors.isEmpty()) {
            return content;
        }
        StringReader reader = new StringReader(content.toString());
        Object writer = null;
        StopWatch stopWatch = new StopWatch();
        for (ResourcePostProcessor processor : processors) {
            stopWatch.start("Using " + processor.getClass().getSimpleName());
            writer = new StringWriter();
            try {
                this.callbackRegistry.onBeforePostProcess();
                this.decorateProcessor(processor).process(reader, (Writer)writer);
            }
            finally {
                stopWatch.stop();
                this.callbackRegistry.onAfterPostProcess();
                IOUtils.closeQuietly((Reader)reader);
                IOUtils.closeQuietly((Writer)writer);
            }
            reader = new StringReader(writer.toString());
        }
        LOG.debug(stopWatch.prettyPrint());
        return writer.toString();
    }

    private ResourcePostProcessor decorateProcessor(ResourcePostProcessor processor) {
        ExceptionHandlingProcessorDecorator decorated = new ExceptionHandlingProcessorDecorator(processor);
        this.injector.inject(decorated);
        return decorated;
    }
}

