/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.manager.factory;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.manager.WroManager;
import ro.isdc.wro.manager.factory.BaseWroManagerFactory;
import ro.isdc.wro.manager.factory.WroManagerFactory;

public class DefaultWroManagerFactory
implements WroManagerFactory {
    private final WroManagerFactory factory;

    public DefaultWroManagerFactory(WroConfiguration configuration) {
        this.factory = this.initFactory(configuration);
    }

    private WroManagerFactory initFactory(WroConfiguration configuration) {
        Validate.notNull((Object)configuration);
        if (StringUtils.isEmpty((CharSequence)configuration.getWroManagerClassName())) {
            return this.newManagerFactory();
        }
        Class<?> factoryClass = null;
        try {
            factoryClass = Thread.currentThread().getContextClassLoader().loadClass(configuration.getWroManagerClassName());
            return (WroManagerFactory)factoryClass.newInstance();
        }
        catch (Exception e) {
            throw new WroRuntimeException("Exception while loading WroManagerFactory class", e);
        }
    }

    protected WroManagerFactory newManagerFactory() {
        return new BaseWroManagerFactory();
    }

    public void onCachePeriodChanged(long value) {
        this.factory.onCachePeriodChanged(value);
    }

    public void onModelPeriodChanged(long value) {
        this.factory.onModelPeriodChanged(value);
    }

    public WroManager create() {
        return (WroManager)this.factory.create();
    }

    public void destroy() {
        this.factory.destroy();
    }

    public final WroManagerFactory getFactory() {
        return this.factory;
    }
}

