/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.manager;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.cache.CacheEntry;
import ro.isdc.wro.cache.CacheStrategy;
import ro.isdc.wro.cache.ContentHashEntry;
import ro.isdc.wro.config.WroConfigurationChangeListener;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.manager.ReloadCacheRunnable;
import ro.isdc.wro.manager.ReloadModelRunnable;
import ro.isdc.wro.manager.ResourceBundleProcessor;
import ro.isdc.wro.manager.callback.LifecycleCallback;
import ro.isdc.wro.manager.callback.LifecycleCallbackRegistry;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.group.GroupExtractor;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.group.processor.GroupsProcessor;
import ro.isdc.wro.model.group.processor.Injector;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.processor.factory.ProcessorsFactory;
import ro.isdc.wro.model.resource.support.hash.HashStrategy;
import ro.isdc.wro.model.resource.support.naming.NamingStrategy;
import ro.isdc.wro.util.LazyInitializer;
import ro.isdc.wro.util.SchedulerHelper;
import ro.isdc.wro.util.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WroManager
implements WroConfigurationChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(WroManager.class);
    @Inject
    private WroModelFactory modelFactory;
    @Inject
    private GroupExtractor groupExtractor;
    @Inject
    private CacheStrategy<CacheEntry, ContentHashEntry> cacheStrategy;
    @Inject
    private ProcessorsFactory processorsFactory;
    @Inject
    private UriLocatorFactory uriLocatorFactory;
    @Inject
    private NamingStrategy namingStrategy;
    @Inject
    private LifecycleCallbackRegistry callbackRegistry;
    @Inject
    private GroupsProcessor groupsProcessor;
    @Inject
    private WroConfiguration config;
    @Inject
    private HashStrategy hashStrategy;
    @Inject
    private Injector injector;
    private List<Transformer<WroModel>> modelTransformers = Collections.emptyList();
    private final SchedulerHelper modelSchedulerHelper;
    private final SchedulerHelper cacheSchedulerHelper = SchedulerHelper.create(new LazyInitializer<Runnable>(){

        @Override
        protected Runnable initialize() {
            return new ReloadCacheRunnable(WroManager.this);
        }
    }, ReloadCacheRunnable.class.getSimpleName());
    private ResourceBundleProcessor resourceBundleProcessor;

    public WroManager() {
        this.modelSchedulerHelper = SchedulerHelper.create(new LazyInitializer<Runnable>(){

            @Override
            protected Runnable initialize() {
                return new ReloadModelRunnable(WroManager.this);
            }
        }, ReloadModelRunnable.class.getSimpleName());
        this.resourceBundleProcessor = new ResourceBundleProcessor();
    }

    public final void process() throws IOException {
        this.validate();
        this.cacheSchedulerHelper.scheduleWithPeriod(this.config.getCacheUpdatePeriod());
        this.modelSchedulerHelper.scheduleWithPeriod(this.config.getModelUpdatePeriod());
        this.injector.inject(this.getResourceBundleProcessor());
        this.getResourceBundleProcessor().serveProcessedBundle();
    }

    private ResourceBundleProcessor getResourceBundleProcessor() {
        if (this.resourceBundleProcessor == null) {
            this.resourceBundleProcessor = new ResourceBundleProcessor();
        }
        return this.resourceBundleProcessor;
    }

    public final String encodeVersionIntoGroupPath(String groupName, ResourceType resourceType, boolean minimize) {
        CacheEntry key = new CacheEntry(groupName, resourceType, minimize);
        ContentHashEntry cacheValue = this.cacheStrategy.get(key);
        String groupUrl = this.groupExtractor.encodeGroupUrl(groupName, resourceType, minimize);
        return this.formatVersionedResource(cacheValue.getHash(), groupUrl);
    }

    protected String formatVersionedResource(String hash, String resourcePath) {
        return String.format("%s/%s", hash, resourcePath);
    }

    @Override
    public final void onCachePeriodChanged(long period) {
        LOG.info("onCachePeriodChanged with value {} has been triggered!", (Object)period);
        this.cacheSchedulerHelper.scheduleWithPeriod(period);
        this.cacheStrategy.clear();
    }

    @Override
    public final void onModelPeriodChanged(long period) {
        LOG.info("onModelPeriodChanged with value {} has been triggered!", (Object)period);
        this.getModelFactory().destroy();
        this.modelSchedulerHelper.scheduleWithPeriod(period);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        try {
            this.cacheSchedulerHelper.destroy();
            this.modelSchedulerHelper.destroy();
            this.cacheStrategy.destroy();
            this.modelFactory.destroy();
        }
        catch (Exception e) {
            LOG.error("Exception occured during manager destroy!!!");
        }
        finally {
            LOG.info("WroManager destroyed");
        }
    }

    private void validate() {
        Validate.notNull(this.cacheStrategy, (String)"cacheStrategy was not set!", (Object[])new Object[0]);
        Validate.notNull((Object)this.groupsProcessor, (String)"groupsProcessor was not set!", (Object[])new Object[0]);
        Validate.notNull((Object)this.uriLocatorFactory, (String)"uriLocatorFactory was not set!", (Object[])new Object[0]);
        Validate.notNull((Object)this.processorsFactory, (String)"processorsFactory was not set!", (Object[])new Object[0]);
        Validate.notNull((Object)this.groupExtractor, (String)"GroupExtractor was not set!", (Object[])new Object[0]);
        Validate.notNull((Object)this.modelFactory, (String)"ModelFactory was not set!", (Object[])new Object[0]);
        Validate.notNull(this.cacheStrategy, (String)"cacheStrategy was not set!", (Object[])new Object[0]);
        Validate.notNull((Object)this.hashStrategy, (String)"HashBuilder was not set!", (Object[])new Object[0]);
    }

    public final WroManager setGroupExtractor(GroupExtractor groupExtractor) {
        Validate.notNull((Object)groupExtractor);
        this.groupExtractor = groupExtractor;
        return this;
    }

    public final WroManager setModelFactory(WroModelFactory modelFactory) {
        Validate.notNull((Object)modelFactory);
        this.modelFactory = modelFactory;
        return this;
    }

    public final WroManager setCacheStrategy(CacheStrategy<CacheEntry, ContentHashEntry> cacheStrategy) {
        Validate.notNull(cacheStrategy);
        this.cacheStrategy = cacheStrategy;
        return this;
    }

    public final WroManager setHashStrategy(HashStrategy hashStrategy) {
        Validate.notNull((Object)hashStrategy);
        this.hashStrategy = hashStrategy;
        return this;
    }

    public final HashStrategy getHashStrategy() {
        return this.hashStrategy;
    }

    public final WroModelFactory getModelFactory() {
        return this.modelFactory;
    }

    public final ProcessorsFactory getProcessorsFactory() {
        return this.processorsFactory;
    }

    public final WroManager setProcessorsFactory(ProcessorsFactory processorsFactory) {
        this.processorsFactory = processorsFactory;
        return this;
    }

    public final void setNamingStrategy(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public final WroManager setUriLocatorFactory(UriLocatorFactory uriLocatorFactory) {
        this.uriLocatorFactory = uriLocatorFactory;
        return this;
    }

    public final CacheStrategy<CacheEntry, ContentHashEntry> getCacheStrategy() {
        return this.cacheStrategy;
    }

    public final UriLocatorFactory getUriLocatorFactory() {
        return this.uriLocatorFactory;
    }

    public final NamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public final GroupExtractor getGroupExtractor() {
        return this.groupExtractor;
    }

    public final GroupsProcessor getGroupsProcessor() {
        return this.groupsProcessor;
    }

    public final void registerCallback(LifecycleCallback callback) {
        Validate.notNull((Object)callback);
        this.getCallbackRegistry().registerCallback(callback);
    }

    public final List<Transformer<WroModel>> getModelTransformers() {
        return this.modelTransformers;
    }

    public final void setModelTransformers(List<Transformer<WroModel>> modelTransformers) {
        this.modelTransformers = modelTransformers;
    }

    public LifecycleCallbackRegistry getCallbackRegistry() {
        if (this.callbackRegistry == null) {
            this.callbackRegistry = new LifecycleCallbackRegistry();
        }
        return this.callbackRegistry;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

