/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.manager;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.cache.CacheEntry;
import ro.isdc.wro.cache.CacheStrategy;
import ro.isdc.wro.cache.ContentHashEntry;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.http.support.HttpHeader;
import ro.isdc.wro.model.group.GroupExtractor;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.util.WroUtil;

public class ResourceBundleProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceBundleProcessor.class);
    @Inject
    private CacheStrategy<CacheEntry, ContentHashEntry> cacheStrategy;
    @Inject
    private WroConfiguration config;
    @Inject
    private GroupExtractor groupExtractor;

    private boolean isGzipAllowed() {
        return this.config.isGzipEnabled() && this.isGzipSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void serveProcessedBundle() throws IOException {
        String etagValue;
        ContentHashEntry cacheValue;
        ResourceType type;
        ServletOutputStream os;
        HttpServletResponse response;
        WroConfiguration configuration;
        block8: {
            Context context = Context.get();
            configuration = context.getConfig();
            HttpServletRequest request = context.getRequest();
            response = context.getResponse();
            os = null;
            try {
                type = this.groupExtractor.getResourceType(request);
                String groupName = this.groupExtractor.getGroupName(request);
                boolean minimize = this.groupExtractor.isMinimized(request);
                if (groupName == null || type == null) {
                    throw new WroRuntimeException("No groups found for request: " + request.getRequestURI());
                }
                this.initAggregatedFolderPath(request, type);
                CacheEntry cacheKey = new CacheEntry(groupName, type, minimize);
                cacheValue = this.cacheStrategy.get(cacheKey);
                String ifNoneMatch = request.getHeader(HttpHeader.IF_NONE_MATCH.toString());
                etagValue = String.format("\"%s\"", cacheValue.getHash());
                if (etagValue == null || !etagValue.equals(ifNoneMatch)) break block8;
                LOG.debug("ETag hash detected: {}. Sending {} status code", (Object)etagValue, (Object)304);
                response.setStatus(304);
                if (os == null) return;
            }
            catch (Throwable throwable) {
                if (os == null) throw throwable;
                IOUtils.closeQuietly(os);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)os);
            return;
        }
        if (type != null) {
            response.setContentType(type.getContentType() + "; charset=" + configuration.getEncoding());
        }
        response.setHeader(HttpHeader.ETAG.toString(), etagValue);
        os = response.getOutputStream();
        if (cacheValue.getRawContent() != null) {
            if (this.isGzipAllowed()) {
                response.setContentLength(cacheValue.getGzippedContent().length);
                response.setHeader(HttpHeader.CONTENT_ENCODING.toString(), "gzip");
                response.setHeader("Vary", "Accept-Encoding");
                IOUtils.write((byte[])cacheValue.getGzippedContent(), (OutputStream)os);
            } else {
                response.setContentLength(cacheValue.getRawContent().length());
                IOUtils.write((String)cacheValue.getRawContent(), (OutputStream)os, (String)configuration.getEncoding());
            }
        }
        if (os == null) return;
        IOUtils.closeQuietly((OutputStream)os);
    }

    private boolean isGzipSupported() {
        return WroUtil.isGzipSupported(Context.get().getRequest());
    }

    private void initAggregatedFolderPath(HttpServletRequest request, ResourceType type) {
        if (ResourceType.CSS == type && Context.get().getAggregatedFolderPath() == null) {
            String requestUri = request.getRequestURI();
            String cssFolder = StringUtils.removeEnd((String)requestUri, (String)FilenameUtils.getName((String)requestUri));
            String aggregatedFolder = StringUtils.removeStart((String)cssFolder, (String)request.getContextPath());
            Context.get().setAggregatedFolderPath(aggregatedFolder);
        }
    }
}

