/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.http.support;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.http.support.RedirectedStreamServletResponseWrapper;
import ro.isdc.wro.manager.factory.BaseWroManagerFactory;
import ro.isdc.wro.model.group.processor.Injector;
import ro.isdc.wro.model.group.processor.InjectorBuilder;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.util.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProcessorsFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractProcessorsFilter.class);
    private FilterConfig filterConfig;

    public final void init(FilterConfig config) throws ServletException {
        this.filterConfig = config;
        this.doInit(config);
    }

    protected void doInit(FilterConfig config) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        try {
            Context.set(Context.webContext(request, response, this.filterConfig));
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            RedirectedStreamServletResponseWrapper wrappedResponse = new RedirectedStreamServletResponseWrapper(os, response);
            chain.doFilter((ServletRequest)request, (ServletResponse)wrappedResponse);
            StringReader reader = new StringReader(new String(os.toByteArray(), Context.get().getConfig().getEncoding()));
            StringWriter writer = new StringWriter();
            this.doProcess(reader, writer);
            response.setContentLength(writer.getBuffer().length());
            IOUtils.write((String)writer.toString(), (OutputStream)response.getOutputStream());
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e, response, chain);
        }
        finally {
            Context.unset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doProcess(Reader reader, Writer writer) throws IOException {
        Reader input = reader;
        Object output = null;
        try {
            StopWatch stopWatch = new StopWatch();
            Injector injector = InjectorBuilder.create(new BaseWroManagerFactory()).build();
            List<ResourcePreProcessor> processors = this.getProcessorsList();
            if (processors == null || processors.isEmpty()) {
                IOUtils.copy((Reader)reader, (Writer)writer);
            } else {
                for (ResourcePreProcessor processor : processors) {
                    stopWatch.start("Using " + processor.getClass().getSimpleName());
                    injector.inject(processor);
                    output = new StringWriter();
                    processor.process(null, input, (Writer)output);
                    input = new StringReader(output.toString());
                    stopWatch.stop();
                }
                LOG.debug(stopWatch.prettyPrint());
                writer.write(output.toString());
            }
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    protected void onRuntimeException(RuntimeException e, HttpServletResponse response, FilterChain chain) {
        LOG.debug("RuntimeException occured", (Throwable)e);
        try {
            LOG.debug("Cannot process. Proceeding with chain execution.");
            chain.doFilter((ServletRequest)Context.get().getRequest(), (ServletResponse)response);
        }
        catch (Exception ex) {
            LOG.error("Error while chaining the request.");
        }
    }

    protected abstract List<ResourcePreProcessor> getProcessorsList();

    public void destroy() {
    }
}

