/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.http.handler.factory;

import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.http.handler.ReloadCacheRequestHandler;
import ro.isdc.wro.http.handler.ReloadModelRequestHandler;
import ro.isdc.wro.http.handler.RequestHandler;
import ro.isdc.wro.http.handler.ResourceProxyRequestHandler;
import ro.isdc.wro.http.handler.factory.SimpleRequestHandlerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRequestHandlerFactory
extends SimpleRequestHandlerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRequestHandlerFactory.class);

    public DefaultRequestHandlerFactory() {
        ArrayList<RequestHandler> requestHandlers = new ArrayList<RequestHandler>();
        requestHandlers.add(new ResourceProxyRequestHandler());
        requestHandlers.add(new ReloadCacheRequestHandler());
        requestHandlers.add(new ReloadModelRequestHandler());
        this.addExtensionsHandlers(requestHandlers);
        this.setHandlers(requestHandlers);
    }

    private void addExtensionsHandlers(Collection<RequestHandler> requestHandlers) {
        try {
            RequestHandler requestHandler = (RequestHandler)Class.forName("ro.isdc.wro.extensions.http.handler.ModelAsJsonRequestHandler").newInstance();
            requestHandlers.add(requestHandler);
        }
        catch (Exception e) {
            LOG.info("ExposeModelRequestHandler not found, probably because wro4j-extensions module is missing from classpath.");
        }
    }
}

