/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.http.handler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.http.handler.RequestHandlerSupport;
import ro.isdc.wro.http.support.ContentTypeResolver;
import ro.isdc.wro.http.support.UnauthorizedRequestException;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.support.ResourceAuthorizationManager;

public class ResourceProxyRequestHandler
extends RequestHandlerSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceProxyRequestHandler.class);
    public static final String PARAM_RESOURCE_ID = "id";
    public static final String PATH_RESOURCES = "wroResources";
    @Inject
    private UriLocatorFactory uriLocatorFactory;
    @Inject
    private WroConfiguration config;
    @Inject
    private ResourceAuthorizationManager authManager;

    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String resourceUri = request.getParameter(PARAM_RESOURCE_ID);
        this.verifyAccess(resourceUri, response);
        this.serverProxyResourceUri(resourceUri, response);
    }

    public boolean accept(HttpServletRequest request) {
        return StringUtils.contains((CharSequence)request.getRequestURI(), (CharSequence)PATH_RESOURCES);
    }

    private void serverProxyResourceUri(String resourceUri, HttpServletResponse response) throws IOException {
        LOG.debug("[OK] serving proxy resource: {}", (Object)resourceUri);
        InputStream is = this.uriLocatorFactory.locate(resourceUri);
        ServletOutputStream outputStream = response.getOutputStream();
        response.setContentType(ContentTypeResolver.get(resourceUri, this.config.getEncoding()));
        int length = IOUtils.copy((InputStream)is, (OutputStream)outputStream);
        response.setContentLength(length);
        response.setStatus(200);
        IOUtils.closeQuietly((OutputStream)outputStream);
        IOUtils.closeQuietly((InputStream)is);
    }

    private void verifyAccess(String resourceUri, HttpServletResponse response) {
        if (!this.authManager.isAuthorized(resourceUri)) {
            LOG.debug("[FAIL] Unauthorized proxy resource: {}", (Object)resourceUri);
            response.setStatus(403);
            throw new UnauthorizedRequestException("Unauthorized resource request detected: " + resourceUri);
        }
    }
}

