/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.http;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.factory.PropertiesAndFilterConfigWroConfigurationFactory;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.http.handler.RequestHandler;
import ro.isdc.wro.http.handler.factory.DefaultRequestHandlerFactory;
import ro.isdc.wro.http.handler.factory.RequestHandlerFactory;
import ro.isdc.wro.http.support.HttpHeader;
import ro.isdc.wro.http.support.ServletContextAttributeHelper;
import ro.isdc.wro.manager.WroManager;
import ro.isdc.wro.manager.factory.DefaultWroManagerFactory;
import ro.isdc.wro.manager.factory.InjectableWroManagerFactoryDecorator;
import ro.isdc.wro.manager.factory.WroManagerFactory;
import ro.isdc.wro.model.group.processor.Injector;
import ro.isdc.wro.util.ObjectFactory;
import ro.isdc.wro.util.WroUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WroFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(WroFilter.class);
    private static final String MBEAN_PREFIX = "wro4j-";
    private static final String DEFAULT_CACHE_CONTROL_VALUE = "public, max-age=315360000";
    private FilterConfig filterConfig;
    private WroConfiguration wroConfiguration;
    private InjectableWroManagerFactoryDecorator wroManagerFactory;
    private RequestHandlerFactory requestHandlerFactory = new DefaultRequestHandlerFactory();
    private final Map<String, String> headersMap = new LinkedHashMap<String, String>(){

        @Override
        public String put(String key, String value) {
            return super.put(key.trim().toLowerCase(), value);
        }

        @Override
        public String get(Object key) {
            return (String)super.get(((String)key).toLowerCase());
        }
    };

    protected ObjectFactory<WroConfiguration> newWroConfigurationFactory() {
        return new PropertiesAndFilterConfigWroConfigurationFactory(this.filterConfig);
    }

    public final void init(FilterConfig config) throws ServletException {
        this.filterConfig = config;
        this.wroConfiguration = this.wroConfiguration == null ? this.createConfiguration() : this.wroConfiguration;
        this.wroManagerFactory = new InjectableWroManagerFactoryDecorator(this.createWroManagerFactory());
        this.initHeaderValues();
        this.registerChangeListeners();
        this.initJMX();
        this.doInit(config);
    }

    private WroConfiguration createConfiguration() {
        WroConfiguration configAttribute = ServletContextAttributeHelper.create(this.filterConfig).getWroConfiguration();
        LOG.debug("config attribute: {}", (Object)configAttribute);
        return configAttribute != null ? configAttribute : this.newWroConfigurationFactory().create();
    }

    private WroManagerFactory createWroManagerFactory() {
        if (this.wroManagerFactory == null) {
            WroManagerFactory managerFactoryAttribute = ServletContextAttributeHelper.create(this.filterConfig).getManagerFactory();
            LOG.debug("managerFactory attribute: {}", (Object)managerFactoryAttribute);
            return managerFactoryAttribute != null ? managerFactoryAttribute : this.newWroManagerFactory();
        }
        LOG.debug("created managerFactory: {}", (Object)this.wroManagerFactory);
        return this.wroManagerFactory;
    }

    private void initJMX() {
        try {
            ObjectName name;
            MBeanServer mbeanServer;
            if (this.wroConfiguration.isJmxEnabled() && !(mbeanServer = this.getMBeanServer()).isRegistered(name = new ObjectName(this.newMBeanName(), "type", WroConfiguration.class.getSimpleName()))) {
                mbeanServer.registerMBean(this.wroConfiguration, name);
            }
            LOG.info("wro4j configuration: " + this.wroConfiguration);
        }
        catch (JMException e) {
            LOG.error("Exception occured while registering MBean", (Throwable)e);
        }
    }

    protected String newMBeanName() {
        String mbeanName = this.wroConfiguration.getMbeanName();
        if (StringUtils.isEmpty((CharSequence)mbeanName)) {
            String contextPath = this.getContextPath();
            mbeanName = StringUtils.isEmpty((CharSequence)contextPath) ? "ROOT" : contextPath;
            mbeanName = MBEAN_PREFIX + mbeanName;
        }
        return mbeanName;
    }

    private String getContextPath() {
        String contextPath = null;
        try {
            contextPath = (String)ServletContext.class.getMethod("getContextPath", new Class[0]).invoke((Object)this.filterConfig.getServletContext(), new Object[0]);
        }
        catch (Exception e) {
            contextPath = "DEFAULT";
            LOG.warn("Couldn't identify contextPath because you are using older version of servlet-api (<2.5). Using " + contextPath + " contextPath.");
        }
        return contextPath.replaceFirst("/", "");
    }

    protected MBeanServer getMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }

    private void registerChangeListeners() {
        this.wroConfiguration.registerCacheUpdatePeriodChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                WroFilter.this.initHeaderValues();
                WroFilter.this.wroManagerFactory.onCachePeriodChanged(WroFilter.this.valueAsLong(event.getNewValue()));
            }
        });
        this.wroConfiguration.registerModelUpdatePeriodChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                WroFilter.this.initHeaderValues();
                WroFilter.this.wroManagerFactory.onModelPeriodChanged(WroFilter.this.valueAsLong(event.getNewValue()));
            }
        });
        LOG.debug("Cache & Model change listeners were registered");
    }

    private long valueAsLong(Object value) {
        Validate.notNull((Object)value);
        return Long.valueOf(String.valueOf(value));
    }

    private void initHeaderValues() {
        String headerParam;
        if (!this.wroConfiguration.isDebug()) {
            Long timestamp = new Date().getTime();
            Calendar cal = Calendar.getInstance();
            cal.roll(1, 1);
            this.headersMap.put(HttpHeader.CACHE_CONTROL.toString(), DEFAULT_CACHE_CONTROL_VALUE);
            this.headersMap.put(HttpHeader.LAST_MODIFIED.toString(), WroUtil.toDateAsString(timestamp));
            this.headersMap.put(HttpHeader.EXPIRES.toString(), WroUtil.toDateAsString(cal.getTimeInMillis()));
        }
        if (!StringUtils.isEmpty((CharSequence)(headerParam = this.wroConfiguration.getHeader()))) {
            try {
                if (headerParam.contains("|")) {
                    String[] headers;
                    for (String header : headers = headerParam.split("[|]")) {
                        this.parseHeader(header);
                    }
                } else {
                    this.parseHeader(headerParam);
                }
            }
            catch (Exception e) {
                throw new WroRuntimeException("Invalid header init-param value: " + headerParam + ". A correct value should have the following format: " + "<HEADER_NAME1>: <VALUE1> | <HEADER_NAME2>: <VALUE2>. " + "Ex: <look like this: " + "Expires: Thu, 15 Apr 2010 20:00:00 GMT | cache-control: public", e);
            }
        }
        LOG.debug("Header Values: {}", this.headersMap);
    }

    private void parseHeader(String header) {
        LOG.debug("parseHeader: {}", (Object)header);
        String headerName = header.substring(0, header.indexOf(":"));
        if (!this.headersMap.containsKey(headerName)) {
            this.headersMap.put(headerName, header.substring(header.indexOf(":") + 1));
        }
    }

    protected void doInit(FilterConfig config) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        try {
            Context.set(Context.webContext(request, response, this.filterConfig), this.wroConfiguration);
            if (!this.handledWithRequestHandler(request, response)) {
                this.processRequest(request, response);
                this.onRequestProcessed();
            }
        }
        catch (Exception e) {
            this.onException(e, response, chain);
        }
        finally {
            if (this.getConfiguration().isDisableCache()) {
                LOG.debug("Disable Cache is true. Destroying model...");
                this.wroManagerFactory.create().getModelFactory().destroy();
            }
            Context.unset();
        }
    }

    private boolean handledWithRequestHandler(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Collection handlers = (Collection)this.requestHandlerFactory.create();
        Validate.notNull((Object)handlers, (String)"requestHandlers cannot be null!", (Object[])new Object[0]);
        Injector injector = this.getInjector();
        for (RequestHandler requestHandler : handlers) {
            injector.inject(requestHandler);
            if (!requestHandler.isEnabled() || !requestHandler.accept(request)) continue;
            requestHandler.handle(request, response);
            return true;
        }
        return false;
    }

    Injector getInjector() {
        return this.wroManagerFactory.getInjector();
    }

    protected void onRequestProcessed() {
    }

    private void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.setResponseHeaders(response);
        WroManager manager = this.wroManagerFactory.create();
        manager.process();
    }

    protected void onException(Exception e, HttpServletResponse response, FilterChain chain) {
        RuntimeException re = e instanceof RuntimeException ? (RuntimeException)e : new WroRuntimeException("Unexected exception", e);
        this.onRuntimeException(re, response, chain);
    }

    @Deprecated
    protected void onRuntimeException(RuntimeException e, HttpServletResponse response, FilterChain chain) {
        LOG.debug("RuntimeException occured", (Throwable)e);
        try {
            LOG.debug("Cannot process. Proceeding with chain execution.");
            chain.doFilter((ServletRequest)Context.get().getRequest(), (ServletResponse)response);
        }
        catch (Exception ex) {
            LOG.error("Error while chaining the request: 404");
        }
    }

    protected void setResponseHeaders(HttpServletResponse response) {
        for (Map.Entry<String, String> entry : this.headersMap.entrySet()) {
            response.setHeader(entry.getKey(), entry.getValue());
        }
        if (this.wroConfiguration.isDebug()) {
            WroUtil.addNoCacheHeaders(response);
        }
    }

    public void setWroManagerFactory(WroManagerFactory wroManagerFactory) {
        this.wroManagerFactory = wroManagerFactory != null && !(wroManagerFactory instanceof InjectableWroManagerFactoryDecorator) ? new InjectableWroManagerFactoryDecorator(wroManagerFactory) : (InjectableWroManagerFactoryDecorator)wroManagerFactory;
    }

    public final WroManagerFactory getWroManagerFactory() {
        return (WroManagerFactory)this.wroManagerFactory.getOriginalDecoratedObject();
    }

    public void setRequestHandlerFactory(RequestHandlerFactory requestHandlerFactory) {
        Validate.notNull((Object)requestHandlerFactory);
        this.requestHandlerFactory = requestHandlerFactory;
    }

    protected WroManagerFactory newWroManagerFactory() {
        return new DefaultWroManagerFactory(this.wroConfiguration);
    }

    public final WroConfiguration getConfiguration() {
        return this.wroConfiguration;
    }

    public final void setConfiguration(WroConfiguration config) {
        Validate.notNull((Object)config);
        this.wroConfiguration = config;
    }

    public void destroy() {
        if (this.wroManagerFactory != null) {
            this.wroManagerFactory.destroy();
        }
        if (this.wroConfiguration != null) {
            this.wroConfiguration.destroy();
        }
        Context.destroy();
    }
}

