/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.cache;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.cache.AbstractSynchronizedCacheStrategyDecorator;
import ro.isdc.wro.cache.CacheEntry;
import ro.isdc.wro.cache.CacheStrategy;
import ro.isdc.wro.cache.ContentHashEntry;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.group.processor.GroupsProcessor;
import ro.isdc.wro.model.resource.support.ResourceAuthorizationManager;
import ro.isdc.wro.model.resource.support.hash.HashStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSynchronizedCacheStrategyDecorator
extends AbstractSynchronizedCacheStrategyDecorator<CacheEntry, ContentHashEntry> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSynchronizedCacheStrategyDecorator.class);
    @Inject
    private GroupsProcessor groupsProcessor;
    @Inject
    private HashStrategy hashBuilder;
    @Inject
    private ResourceAuthorizationManager authorizationManager;

    public DefaultSynchronizedCacheStrategyDecorator(CacheStrategy<CacheEntry, ContentHashEntry> cacheStrategy) {
        super(cacheStrategy);
    }

    @Override
    protected ContentHashEntry loadValue(CacheEntry key) {
        LOG.debug("load value in cache for key: " + key);
        String content = this.groupsProcessor.process(key);
        return this.computeCacheValueByContent(content);
    }

    private ContentHashEntry computeCacheValueByContent(String content) {
        String hash = null;
        try {
            if (content != null) {
                LOG.debug("Content to fingerprint: [{}]", (Object)StringUtils.abbreviate((String)content, (int)40));
                hash = this.hashBuilder.getHash(new ByteArrayInputStream(content.getBytes()));
            }
            ContentHashEntry entry = ContentHashEntry.valueOf(content, hash);
            LOG.debug("computed entry: {}", (Object)entry);
            return entry;
        }
        catch (IOException e) {
            throw new RuntimeException("Should never happen", e);
        }
    }

    @Override
    public void put(CacheEntry key, ContentHashEntry value) {
        if (!Context.get().getConfig().isDisableCache()) {
            super.put(key, value);
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.authorizationManager.clear();
    }
}

