/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.locator.wildcard;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.resource.DuplicateResourceDetector;
import ro.isdc.wro.model.resource.locator.wildcard.IOFileFilterDecorator;
import ro.isdc.wro.model.resource.locator.wildcard.WildcardStreamLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWildcardStreamLocator
implements WildcardStreamLocator {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultWildcardStreamLocator.class);
    private static final String WILDCARD_REGEX = "^(?:(?!http))(.)*[\\*\\?]+(.)*";
    private static final String RECURSIVE_WILDCARD = "**";
    private DuplicateResourceDetector duplicateResourceDetector;

    public DefaultWildcardStreamLocator() {
    }

    public DefaultWildcardStreamLocator(DuplicateResourceDetector duplicateResourceDetector) {
        this.duplicateResourceDetector = duplicateResourceDetector;
    }

    @Override
    public boolean hasWildcard(String uri) {
        return uri.matches(WILDCARD_REGEX);
    }

    @Override
    public InputStream locateStream(String uri, File folder) throws IOException {
        Collection<File> files = this.findMatchedFiles(uri, folder);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (File file : files) {
            FileInputStream is = new FileInputStream(file);
            IOUtils.copy((InputStream)is, (OutputStream)out);
            ((InputStream)is).close();
        }
        return new BufferedInputStream(new ByteArrayInputStream(out.toByteArray()));
    }

    private Collection<File> findMatchedFiles(String uri, File folder) throws IOException {
        if (uri == null || folder == null || !folder.isDirectory()) {
            StringBuffer message = new StringBuffer("Invalid folder provided");
            if (folder != null) {
                message.append(", with path: " + folder.getPath());
            }
            message.append(", with fileNameWithWildcard: " + uri);
            throw new IOException(message.toString());
        }
        if (!this.hasWildcard(uri)) {
            throw new IOException("No wildcard detected for the uri: " + uri);
        }
        String wildcard = FilenameUtils.getName((String)uri);
        LOG.debug("uri: " + uri);
        LOG.debug("folder: " + folder.getPath());
        LOG.debug("wildcard: " + wildcard);
        final TreeMap uriToFileMap = new TreeMap();
        final String uriFolder = FilenameUtils.getFullPathNoEndSeparator((String)uri);
        final String parentFolderPath = folder.getPath();
        IOFileFilterDecorator fileFilter = new IOFileFilterDecorator((IOFileFilter)new WildcardFileFilter(wildcard)){

            public boolean accept(File file) {
                boolean accept = super.accept(file);
                if (accept && !file.isDirectory()) {
                    String relativeFilePath = file.getPath().replace(parentFolderPath, "");
                    String resourceUri = uriFolder + relativeFilePath.replace('\\', '/');
                    uriToFileMap.put(resourceUri, file);
                    LOG.debug("foundUri: " + resourceUri);
                }
                return accept;
            }
        };
        FileUtils.listFiles((File)folder, (IOFileFilter)fileFilter, (IOFileFilter)this.getFolderFilter(wildcard));
        LOG.debug("map files: " + uriToFileMap.keySet());
        ArrayList<String> duplicateResourceList = new ArrayList<String>();
        for (String resourceUri : uriToFileMap.keySet()) {
            if (!this.isDuplicateResourceUri(resourceUri)) continue;
            LOG.warn("Duplicate resource detected: " + resourceUri);
            duplicateResourceList.add(resourceUri);
        }
        for (String duplicateResourceUri : duplicateResourceList) {
            uriToFileMap.remove(duplicateResourceUri);
        }
        Collection<File> files = uriToFileMap.values();
        if (files.isEmpty()) {
            String message = "No files found inside the " + folder.getPath() + " for wildcard: " + wildcard;
            LOG.warn(message);
        }
        this.handleFoundFiles(files);
        return files;
    }

    protected void handleFoundFiles(Collection<File> files) {
    }

    private boolean isDuplicateResourceUri(String resourceUri) {
        if (this.duplicateResourceDetector == null) {
            LOG.warn("DuplicateResourceDetector not enabled, assuming no duplicate found for: " + resourceUri);
            return false;
        }
        boolean result = this.duplicateResourceDetector.isDuplicateResourceUri(resourceUri);
        this.duplicateResourceDetector.addResourceUri(resourceUri);
        return result;
    }

    private IOFileFilter getFolderFilter(String wildcard) {
        boolean recursive = wildcard.contains(RECURSIVE_WILDCARD);
        return recursive ? TrueFileFilter.INSTANCE : FalseFileFilter.INSTANCE;
    }
}

