/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource;

import java.util.Collection;
import java.util.HashSet;

public class DuplicateResourceDetector {
    private static final ThreadLocal<DetectorContext> DETECTOR_CONTEXT = new ThreadLocal();

    private DetectorContext getSafeContext() {
        DetectorContext context = DETECTOR_CONTEXT.get();
        if (context == null) {
            context = new DetectorContext();
            DETECTOR_CONTEXT.set(context);
        }
        return DETECTOR_CONTEXT.get();
    }

    public void addResourceUri(String resourceUri) {
        this.getSafeContext().resourceUris.add(resourceUri);
    }

    public boolean isDuplicateResourceUri(String resourceUri) {
        if (resourceUri == null) {
            throw new IllegalArgumentException("ResourceUri cannot be null!");
        }
        return this.getSafeContext().resourceUris.contains(resourceUri);
    }

    public void reset() {
        DETECTOR_CONTEXT.remove();
    }

    private class DetectorContext {
        private final Collection<String> resourceUris = new HashSet<String>();

        private DetectorContext() {
        }
    }
}

