/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.group.processor;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.group.processor.GroupsProcessor;
import ro.isdc.wro.model.group.processor.Minimize;
import ro.isdc.wro.model.resource.DuplicateResourceDetector;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.util.StopWatch;
import ro.isdc.wro.util.encoding.SmartEncodingInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PreProcessorExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(PreProcessorExecutor.class);
    private final UriLocatorFactory uriLocatorFactory;
    private final DuplicateResourceDetector duplicateResourceDetector;

    public PreProcessorExecutor(UriLocatorFactory uriLocatorFactory, DuplicateResourceDetector duplicateResourceDetector) {
        if (uriLocatorFactory == null) {
            throw new IllegalArgumentException("uriLocatorFactory cannot be null!");
        }
        if (duplicateResourceDetector == null) {
            throw new IllegalArgumentException("duplicateResourceDetector cannot be null!");
        }
        this.uriLocatorFactory = uriLocatorFactory;
        this.duplicateResourceDetector = duplicateResourceDetector;
    }

    public String processAndMerge(List<Resource> resources, boolean minimize) throws IOException {
        StringBuffer result = new StringBuffer();
        for (Resource resource : resources) {
            LOG.debug("merging resource: " + resource);
            result.append(this.processSingleResource(resource, resources, minimize));
        }
        return result.toString();
    }

    private String processSingleResource(Resource resource, List<Resource> resources, boolean minimize) throws IOException {
        Collection<ResourcePreProcessor> processors = this.getPreProcessorsByType(resource.getType());
        if (!minimize) {
            GroupsProcessor.removeMinimizeAwareProcessors(processors);
        }
        return this.applyPreProcessors(resource, resources, processors);
    }

    private String applyPreProcessors(Resource resource, List<Resource> resources, Collection<ResourcePreProcessor> processors) throws IOException {
        String resourceContent = this.getResourceContent(resource, resources);
        if (processors.isEmpty()) {
            return resourceContent;
        }
        Object writer = null;
        StopWatch stopWatch = new StopWatch();
        for (ResourcePreProcessor processor : processors) {
            boolean applyProcessor;
            stopWatch.start("Using " + processor.getClass().getSimpleName());
            writer = new StringWriter();
            boolean bl = applyProcessor = resource.isMinimize() || !processor.getClass().isAnnotationPresent(Minimize.class);
            if (applyProcessor) {
                LOG.debug("PreProcessing - " + processor.getClass().getSimpleName());
                StringReader reader = new StringReader(resourceContent);
                processor.process(resource, reader, (Writer)writer);
                ((Reader)reader).close();
            } else {
                ((Writer)writer).write(resourceContent);
                LOG.debug("skipped processing on resource: " + resource);
            }
            resourceContent = writer.toString();
            stopWatch.stop();
        }
        LOG.debug(stopWatch.prettyPrint());
        return writer.toString();
    }

    private String getResourceContent(Resource resource, List<Resource> resources) throws IOException {
        try {
            for (Resource r : resources) {
                this.duplicateResourceDetector.addResourceUri(r.getUri());
            }
            InputStream is = this.uriLocatorFactory.locate(resource.getUri());
            String result = IOUtils.toString((InputStream)new SmartEncodingInputStream(is));
            is.close();
            String string = result;
            return string;
        }
        catch (IOException e) {
            LOG.warn("Invalid resource found: " + resource);
            if (this.ignoreMissingResources()) {
                String string = "";
                return string;
            }
            LOG.warn("Cannot continue processing. IgnoreMissingResources is + " + this.ignoreMissingResources());
            throw e;
        }
        finally {
            this.duplicateResourceDetector.reset();
        }
    }

    protected abstract boolean ignoreMissingResources();

    protected abstract Collection<ResourcePreProcessor> getPreProcessorsByType(ResourceType var1);
}

