/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.group.processor;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.model.group.Group;
import ro.isdc.wro.model.group.processor.AbstractGroupsProcessor;
import ro.isdc.wro.model.group.processor.Minimize;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.util.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupsProcessor
extends AbstractGroupsProcessor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(GroupsProcessor.class);

    static <T> void removeMinimizeAwareProcessors(Collection<T> processors) {
        ArrayList<T> minimizeAwareProcessors = new ArrayList<T>();
        for (T processor : processors) {
            if (!processor.getClass().isAnnotationPresent(Minimize.class)) continue;
            minimizeAwareProcessors.add(processor);
        }
        processors.removeAll(minimizeAwareProcessors);
    }

    public String process(Collection<Group> groups, ResourceType type, boolean minimize) {
        if (groups == null) {
            throw new IllegalArgumentException("List of groups cannot be null!");
        }
        if (type == null) {
            throw new IllegalArgumentException("ResourceType cannot be null!");
        }
        this.getDuplicateResourceDetector().reset();
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("filter resources");
        List<Resource> filteredResources = this.getFilteredResources(groups, type);
        try {
            stopWatch.stop();
            stopWatch.start("pre process and merge");
            String result = this.getPreProcessorExecutor().processAndMerge(filteredResources, minimize);
            stopWatch.stop();
            stopWatch.start("post process");
            String postProcessedResult = this.applyPostProcessors(type, result, minimize);
            stopWatch.stop();
            LOG.debug(stopWatch.prettyPrint());
            return postProcessedResult;
        }
        catch (IOException e) {
            throw new WroRuntimeException("Exception while merging resources", e);
        }
    }

    private String applyPostProcessors(ResourceType resourceType, String content, boolean minimize) throws IOException {
        if (content == null) {
            throw new IllegalArgumentException("content cannot be null!");
        }
        Collection<ResourcePostProcessor> processors = this.getPostProcessorsByType(resourceType);
        processors.addAll(this.getPostProcessorsByType(null));
        if (!minimize) {
            GroupsProcessor.removeMinimizeAwareProcessors(processors);
        }
        String output = this.applyPostProcessors(processors, content);
        return output;
    }

    private String applyPostProcessors(Collection<ResourcePostProcessor> processors, String content) throws IOException {
        if (processors.isEmpty()) {
            return content;
        }
        StringReader input = new StringReader(content.toString());
        Object output = null;
        StopWatch stopWatch = new StopWatch();
        for (ResourcePostProcessor processor : processors) {
            stopWatch.start("Using " + processor.getClass().getSimpleName());
            output = new StringWriter();
            processor.process(input, (Writer)output);
            input = new StringReader(output.toString());
            stopWatch.stop();
        }
        LOG.debug(stopWatch.prettyPrint());
        return output.toString();
    }
}

