/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.manager.factory;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.manager.factory.BaseWroManagerFactory;
import ro.isdc.wro.model.group.processor.GroupsProcessor;
import ro.isdc.wro.model.resource.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.locator.ClasspathUriLocator;
import ro.isdc.wro.model.resource.locator.ServletContextUriLocator;
import ro.isdc.wro.model.resource.locator.UriLocator;
import ro.isdc.wro.model.resource.locator.UrlUriLocator;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.impl.BomStripperPreProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.ConformColorsCssProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.CssCompressorProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.CssDataUriPreProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.CssImportPreProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.CssUrlRewritingProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.CssVariablesProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.JawrCssMinifierProcessor;
import ro.isdc.wro.model.resource.processor.impl.css.VariablizeColorsCssProcessor;
import ro.isdc.wro.model.resource.processor.impl.js.JSMinProcessor;
import ro.isdc.wro.model.resource.processor.impl.js.SemicolonAppenderPreProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurableWroManagerFactory
extends BaseWroManagerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurableWroManagerFactory.class);
    public static final String PARAM_URI_LOCATORS = "uriLocators";
    public static final String PARAM_PRE_PROCESSORS = "preProcessors";
    public static final String PARAM_POST_PROCESSORS = "postProcessors";
    private static final String TOKEN_DELIMITER = ",";
    private final Map<String, ResourcePreProcessor> preProcessors = new LinkedHashMap<String, ResourcePreProcessor>();
    private final Map<String, ResourcePostProcessor> postProcessors = new LinkedHashMap<String, ResourcePostProcessor>();
    private final Map<String, UriLocator> locators = new LinkedHashMap<String, UriLocator>();

    public ConfigurableWroManagerFactory() {
        this.initProcessors();
        this.initLocators();
    }

    private void initLocators() {
        this.locators.put("servletContext", new ServletContextUriLocator());
        this.locators.put("classpath", new ClasspathUriLocator());
        this.locators.put("url", new UrlUriLocator());
        this.contributeLocators(this.locators);
    }

    private void initProcessors() {
        this.preProcessors.put("cssUrlRewriting", new CssUrlRewritingProcessor());
        this.preProcessors.put("bomStripper", new BomStripperPreProcessor());
        this.preProcessors.put("cssImport", new CssImportPreProcessor());
        this.preProcessors.put("cssVariables", new CssVariablesProcessor());
        this.preProcessors.put("semicolonAppender", new SemicolonAppenderPreProcessor());
        this.preProcessors.put("cssDataUri", new CssDataUriPreProcessor());
        this.preProcessors.put("cssCompressor", new CssCompressorProcessor());
        this.preProcessors.put("cssMinJawr", new JawrCssMinifierProcessor());
        this.preProcessors.put("jsMin", new JSMinProcessor());
        this.preProcessors.put("variablizeColors", new VariablizeColorsCssProcessor());
        this.preProcessors.put("conformColors", new ConformColorsCssProcessor());
        this.postProcessors.put("cssVariables", new CssVariablesProcessor());
        this.postProcessors.put("cssCompressor", new CssCompressorProcessor());
        this.postProcessors.put("cssMinJawr", new JawrCssMinifierProcessor());
        this.postProcessors.put("jsMin", new JSMinProcessor());
        this.preProcessors.put("variablizeColors", new VariablizeColorsCssProcessor());
        this.preProcessors.put("conformColors", new ConformColorsCssProcessor());
        this.contributePreProcessors(this.preProcessors);
        this.contributePostProcessors(this.postProcessors);
    }

    protected void contributeLocators(Map<String, UriLocator> map) {
    }

    protected void contributePreProcessors(Map<String, ResourcePreProcessor> map) {
    }

    protected void contributePostProcessors(Map<String, ResourcePostProcessor> map) {
    }

    @Override
    protected void configureUriLocatorFactory(UriLocatorFactory factory) {
        for (UriLocator locator : this.getLocators()) {
            factory.addUriLocator(new UriLocator[]{locator});
        }
    }

    @Override
    protected final void configureGroupsProcessor(GroupsProcessor groupsProcessor) {
        groupsProcessor.setResourcePreProcessors(this.getPreProcessors());
        groupsProcessor.setResourcePostProcessors(this.getPostProcessors());
    }

    List<UriLocator> getLocators() {
        return this.getListOfItems(PARAM_URI_LOCATORS, this.locators);
    }

    List<ResourcePreProcessor> getPreProcessors() {
        return this.getListOfItems(PARAM_PRE_PROCESSORS, this.preProcessors);
    }

    List<ResourcePostProcessor> getPostProcessors() {
        return this.getListOfItems(PARAM_POST_PROCESSORS, this.postProcessors);
    }

    private <T> List<T> getListOfItems(String initParamName, Map<String, T> map) {
        ArrayList<T> list = new ArrayList<T>();
        String paramValue = Context.get().getFilterConfig().getInitParameter(initParamName);
        LOG.debug("paramValue: " + paramValue);
        List<String> tokens = this.getTokens(paramValue);
        if (tokens.isEmpty()) {
            String message = "No '" + initParamName + "' initParam was set";
            LOG.warn(message);
            return list;
        }
        for (String token : tokens) {
            T item = map.get(token);
            if (item == null) {
                LOG.info("Available " + initParamName + " are: " + map.keySet());
                throw new WroRuntimeException("Invalid " + initParamName + " name: " + token);
            }
            LOG.debug("Found " + initParamName + " for name: " + token + " : " + item);
            list.add(item);
        }
        return list;
    }

    private List<String> getTokens(String input) {
        ArrayList<String> locatorsList = new ArrayList<String>();
        if (input != null) {
            StringTokenizer st = new StringTokenizer(input, TOKEN_DELIMITER);
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (StringUtils.isEmpty((String)token)) continue;
                locatorsList.add(token);
            }
        }
        return locatorsList;
    }
}

