/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.manager;

import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.cache.CacheEntry;
import ro.isdc.wro.cache.CacheStrategy;
import ro.isdc.wro.cache.ContentHashEntry;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.WroConfigurationChangeListener;
import ro.isdc.wro.http.HttpHeader;
import ro.isdc.wro.http.UnauthorizedRequestException;
import ro.isdc.wro.manager.CacheChangeCallbackAware;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.group.Group;
import ro.isdc.wro.model.group.GroupExtractor;
import ro.isdc.wro.model.group.processor.GroupsProcessor;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.processor.impl.css.CssUrlRewritingProcessor;
import ro.isdc.wro.model.resource.util.HashBuilder;
import ro.isdc.wro.util.StopWatch;
import ro.isdc.wro.util.WroUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WroManager
implements WroConfigurationChangeListener,
CacheChangeCallbackAware {
    private static final Logger LOG = LoggerFactory.getLogger(WroManager.class);
    private static final ByteArrayInputStream EMPTY_STREAM = new ByteArrayInputStream(new byte[0]);
    public static final String PATH_API = "wroAPI";
    public static final String API_RELOAD_CACHE = "wroAPI/reloadCache";
    public static final String API_RELOAD_MODEL = "wroAPI/reloadModel";
    private WroModelFactory modelFactory;
    private GroupExtractor groupExtractor;
    private GroupsProcessor groupsProcessor;
    private HashBuilder hashBuilder;
    private CacheStrategy<CacheEntry, ContentHashEntry> cacheStrategy;
    private PropertyChangeListener cacheChangeCallback;
    private ScheduledExecutorService scheduler;

    public final void process() throws IOException {
        HttpServletRequest request = Context.get().getRequest();
        HttpServletResponse response = Context.get().getResponse();
        LOG.debug("processing: " + request.getRequestURI());
        this.validate();
        InputStream is = null;
        if (this.matchesUrl(request, API_RELOAD_CACHE)) {
            Context.get().getConfig().reloadCache();
            WroUtil.addNoCacheHeaders(response);
            return;
        }
        if (this.matchesUrl(request, API_RELOAD_MODEL)) {
            Context.get().getConfig().reloadModel();
            WroUtil.addNoCacheHeaders(response);
            return;
        }
        is = this.isProxyResourceRequest(request) ? this.locateInputeStream(request) : this.buildGroupsInputStream(request, response);
        if (is == null) {
            throw new WroRuntimeException("Cannot process this request: " + request.getRequestURL());
        }
        OutputStream os = this.getGzipedOutputStream(response);
        IOUtils.copy((InputStream)is, (OutputStream)os);
        is.close();
        os.close();
    }

    private boolean matchesUrl(HttpServletRequest request, String apiPath) {
        Pattern pattern = Pattern.compile(".*" + apiPath + "[/]?", 2);
        Matcher m = pattern.matcher(request.getRequestURI());
        return m.matches();
    }

    private boolean isProxyResourceRequest(HttpServletRequest request) {
        return request.getRequestURI().contains("wroResources");
    }

    private OutputStream getGzipedOutputStream(HttpServletResponse response) throws IOException {
        if (Context.get().getConfig().isGzipEnabled() && this.isGzipSupported()) {
            response.setHeader(HttpHeader.CONTENT_ENCODING.toString(), "gzip");
            response.setHeader("Vary", "Accept-Encoding");
            return new GZIPOutputStream((OutputStream)response.getOutputStream());
        }
        LOG.debug("Gziping outputStream response");
        return response.getOutputStream();
    }

    private InputStream buildGroupsInputStream(HttpServletRequest request, HttpServletResponse response) throws IOException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("buildGroupsStream");
        ByteArrayInputStream inputStream = null;
        ResourceType type = this.groupExtractor.getResourceType(request);
        String groupName = this.groupExtractor.getGroupName(request);
        boolean minimize = this.groupExtractor.isMinimized(request);
        if (groupName == null || type == null) {
            throw new WroRuntimeException("No groups found for request: " + request.getRequestURI());
        }
        this.initScheduler();
        ContentHashEntry contentHashEntry = this.getContentHashEntry(groupName, type, minimize);
        String ifNoneMatch = request.getHeader(HttpHeader.IF_NONE_MATCH.toString());
        String etagValue = String.format("\"%s\"", contentHashEntry.getHash());
        if (etagValue != null && etagValue.equals(ifNoneMatch)) {
            LOG.debug("ETag hash detected: " + etagValue + ". Sending " + 304 + " status code");
            response.setStatus(304);
            return EMPTY_STREAM;
        }
        if (contentHashEntry.getContent() != null) {
            response.setContentLength(contentHashEntry.getContent().length());
            inputStream = new ByteArrayInputStream(contentHashEntry.getContent().getBytes());
        }
        if (type != null) {
            response.setContentType(type.getContentType());
        }
        response.setHeader(HttpHeader.ETAG.toString(), etagValue);
        stopWatch.stop();
        LOG.debug("WroManager process time: " + stopWatch.prettyPrint());
        return inputStream;
    }

    public final String encodeVersionIntoGroupPath(String groupName, ResourceType resourceType, boolean minimize) {
        try {
            ContentHashEntry contentHashEntry = this.getContentHashEntry(groupName, resourceType, minimize);
            String groupUrl = this.groupExtractor.encodeGroupUrl(groupName, resourceType, minimize);
            return this.formatVersionedResource(contentHashEntry.getHash(), groupUrl);
        }
        catch (IOException e) {
            return "";
        }
    }

    protected String formatVersionedResource(String hash, String resourcePath) {
        return String.format("%s/%s", hash, resourcePath);
    }

    private ContentHashEntry getContentHashEntry(String groupName, ResourceType type, boolean minimize) throws IOException {
        CacheEntry cacheEntry = new CacheEntry(groupName, type, minimize);
        LOG.debug("Searching cache entry: " + cacheEntry);
        ContentHashEntry contentHashEntry = this.cacheStrategy.get(cacheEntry);
        if (contentHashEntry == null) {
            LOG.debug("Cache is empty. Perform processing...");
            ArrayList<Group> groupAsList = new ArrayList<Group>();
            Group group = this.modelFactory.getInstance().getGroupByName(groupName);
            groupAsList.add(group);
            String content = this.groupsProcessor.process(groupAsList, type, minimize);
            contentHashEntry = this.getContentHashEntryByContent(content);
            if (!Context.get().getConfig().isDisableCache()) {
                this.cacheStrategy.put(cacheEntry, contentHashEntry);
            }
        }
        return contentHashEntry;
    }

    private ContentHashEntry getContentHashEntryByContent(String content) throws IOException {
        String hash = null;
        if (content != null) {
            LOG.debug("Content to fingerprint: [" + StringUtils.abbreviate((String)content, (int)40) + "]");
            hash = this.hashBuilder.getHash(new ByteArrayInputStream(content.getBytes()));
        }
        ContentHashEntry entry = ContentHashEntry.valueOf(content, hash);
        LOG.debug("computed entry: " + entry);
        return entry;
    }

    private void initScheduler() {
        if (this.scheduler == null) {
            long period = Context.get().getConfig().getCacheUpdatePeriod();
            LOG.debug("runing thread with period of " + period);
            if (period > 0L) {
                this.scheduler = Executors.newSingleThreadScheduledExecutor(WroUtil.createDaemonThreadFactory());
                this.scheduler.scheduleWithFixedDelay(this.getSchedulerRunnable(), 0L, period, TimeUnit.SECONDS);
            }
        }
    }

    private Runnable getSchedulerRunnable() {
        return new Runnable(){

            public void run() {
                try {
                    if (WroManager.this.cacheChangeCallback != null) {
                        WroManager.this.cacheChangeCallback.propertyChange(null);
                    }
                    LOG.info("reloading cache");
                    WroModel model = WroManager.this.modelFactory.getInstance();
                    Set<Group> groups = model.getGroups();
                    for (Group group : groups) {
                        for (ResourceType resourceType : ResourceType.values()) {
                            Boolean[] minimizeValues;
                            if (!group.hasResourcesOfType(resourceType)) continue;
                            HashSet<Group> groupAsList = new HashSet<Group>();
                            groupAsList.add(group);
                            Boolean[] arr$ = minimizeValues = new Boolean[]{true, false};
                            int len$ = arr$.length;
                            for (int i$ = 0; i$ < len$; ++i$) {
                                boolean minimize = arr$[i$];
                                String content = WroManager.this.groupsProcessor.process(groupAsList, resourceType, minimize);
                                WroManager.this.cacheStrategy.put(new CacheEntry(group.getName(), resourceType, minimize), WroManager.this.getContentHashEntryByContent(content));
                            }
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error("Exception occured: ", (Throwable)e);
                }
            }
        };
    }

    @Override
    public final void registerCallback(PropertyChangeListener callback) {
        this.cacheChangeCallback = callback;
    }

    protected boolean isGzipSupported() {
        return WroUtil.isGzipSupported(Context.get().getRequest());
    }

    private InputStream locateInputeStream(HttpServletRequest request) throws IOException {
        String resourceId = request.getParameter("id");
        LOG.debug("locating stream for resourceId: " + resourceId);
        CssUrlRewritingProcessor processor = this.groupsProcessor.findPreProcessorByClass(CssUrlRewritingProcessor.class);
        if (processor != null && !processor.isUriAllowed(resourceId)) {
            throw new UnauthorizedRequestException("Unauthorized resource request detected! " + request.getRequestURI());
        }
        return this.groupsProcessor.getUriLocatorFactory().locate(resourceId);
    }

    @Override
    public final void onCachePeriodChanged() {
        LOG.info("CacheChange event triggered!");
        if (this.scheduler != null) {
            this.scheduler.shutdown();
            this.scheduler = null;
        }
        this.cacheStrategy.clear();
    }

    @Override
    public final void onModelPeriodChanged() {
        LOG.info("ModelChange event triggered!");
        this.onCachePeriodChanged();
        if (this.modelFactory instanceof WroConfigurationChangeListener) {
            ((WroConfigurationChangeListener)((Object)this.modelFactory)).onModelPeriodChanged();
        }
    }

    public final void destroy() {
        LOG.debug("WroManager destroyed");
        this.cacheStrategy.destroy();
        this.modelFactory.destroy();
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
    }

    private void validate() {
        if (this.groupExtractor == null) {
            throw new WroRuntimeException("GroupExtractor was not set!");
        }
        if (this.modelFactory == null) {
            throw new WroRuntimeException("ModelFactory was not set!");
        }
        if (this.groupsProcessor == null) {
            throw new WroRuntimeException("GroupsProcessor was not set!");
        }
        if (this.cacheStrategy == null) {
            throw new WroRuntimeException("cacheStrategy was not set!");
        }
        if (this.hashBuilder == null) {
            throw new WroRuntimeException("hashBuilder was not set!");
        }
    }

    public final void setGroupExtractor(GroupExtractor groupExtractor) {
        this.groupExtractor = groupExtractor;
    }

    public final void setGroupsProcessor(GroupsProcessor groupsProcessor) {
        this.groupsProcessor = groupsProcessor;
    }

    public final void setModelFactory(WroModelFactory modelFactory) {
        this.modelFactory = modelFactory;
    }

    public final void setCacheStrategy(CacheStrategy<CacheEntry, ContentHashEntry> cacheStrategy) {
        this.cacheStrategy = cacheStrategy;
    }

    public void setHashBuilder(HashBuilder contentDigester) {
        this.hashBuilder = contentDigester;
    }

    public final WroModel getModel() {
        return this.modelFactory.getInstance();
    }
}

