/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.LinkedList;
import org.zkoss.lang.Objects;
import org.zkoss.util.ArraysX;

public class FastReadArray
implements Serializable,
Cloneable {
    private Object[] _ary;

    public FastReadArray() {
        this._ary = new Object[0];
    }

    public FastReadArray(Class klass) {
        this._ary = (Object[])Array.newInstance(klass, 0);
    }

    public Object[] toArray() {
        return this._ary;
    }

    public boolean isEmpty() {
        return this._ary.length == 0;
    }

    public int size() {
        return this._ary.length;
    }

    public synchronized void add(Object val) {
        Object[] ary = (Object[])ArraysX.resize(this._ary, this._ary.length + 1);
        ary[this._ary.length] = val;
        this._ary = ary;
    }

    public synchronized boolean remove(Object val) {
        LinkedList<Object> l = new LinkedList<Object>();
        boolean found = false;
        for (int j = 0; j < this._ary.length; ++j) {
            if (found || !Objects.equals(val, this._ary[j])) {
                l.add(this._ary[j]);
                continue;
            }
            found = true;
        }
        if (found) {
            this._ary = l.toArray((Object[])Array.newInstance(this._ary.getClass().getComponentType(), l.size()));
        }
        return found;
    }

    public synchronized boolean removeBy(Comparable val, boolean atMostOne) {
        LinkedList<Object> l = new LinkedList<Object>();
        boolean found = false;
        for (int j = 0; j < this._ary.length; ++j) {
            if (atMostOne && found || val.compareTo(this._ary[j]) != 0) {
                l.add(this._ary[j]);
                continue;
            }
            found = true;
        }
        if (found) {
            this._ary = l.toArray((Object[])Array.newInstance(this._ary.getClass().getComponentType(), l.size()));
        }
        return found;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FastReadArray)) {
            return false;
        }
        return Objects.equals(this._ary, ((FastReadArray)o)._ary);
    }

    public int hashCode() {
        return Objects.hashCode(this._ary);
    }

    public String toString() {
        return Objects.toString(this._ary);
    }
}

