/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.io;

import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import org.zkoss.io.Repeatable;
import org.zkoss.io.URLReader;

class RepeatableURLReader
extends Reader
implements Repeatable {
    private final URL _url;
    private Reader _in;
    private final String _charset;

    RepeatableURLReader(URL url, String charset) {
        this._url = url;
        this._charset = charset != null ? charset : "UTF-8";
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this._in == null) {
            this._in = new URLReader(this._url, this._charset);
        }
        return this._in.read(cbuf, off, len);
    }

    public void close() throws IOException {
        if (this._in != null) {
            this._in.close();
            this._in = null;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

