/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.xml;

import org.zkoss.idom.Verifier;

public class XMLs {
    public static final String toXMLName(String name) {
        if (name == null || name.length() == 0) {
            return "_";
        }
        StringBuffer sb = null;
        int len = name.length();
        for (int j = 0; j < len; ++j) {
            char cc = name.charAt(j);
            if (j == 0 && !Verifier.isXMLNameStartCharacter(cc) || cc == ':' || !Verifier.isXMLNameCharacter(cc)) {
                if (sb == null) {
                    sb = new StringBuffer(len + 8);
                    if (j > 0) {
                        sb.append(name.substring(0, j));
                    }
                }
                sb.append('_').append(Integer.toHexString(cc));
                continue;
            }
            if (sb == null) continue;
            sb.append(cc);
        }
        return sb != null ? sb.toString() : name;
    }

    public static final String encodeAttribute(String value) {
        StringBuffer sb = null;
        int len = value.length();
        block4: for (int j = 0; j < len; ++j) {
            String rep;
            char cc = value.charAt(j);
            switch (cc) {
                case '\"': {
                    rep = "&quot;";
                    break;
                }
                case '&': {
                    rep = "&amp;";
                    break;
                }
                default: {
                    if (sb == null) continue block4;
                    sb.append(cc);
                    continue block4;
                }
            }
            if (sb == null) {
                sb = new StringBuffer(len + 8);
                if (j > 0) {
                    sb.append(value.substring(0, j));
                }
            }
            sb.append(rep);
        }
        return sb != null ? sb.toString() : value;
    }

    public static final String encodeText(String value) {
        StringBuffer sb = null;
        int len = value.length();
        block5: for (int j = 0; j < len; ++j) {
            String rep;
            char cc = value.charAt(j);
            switch (cc) {
                case '<': {
                    rep = "&lt;";
                    break;
                }
                case '>': {
                    rep = "&gt;";
                    break;
                }
                case '&': {
                    rep = "&amp;";
                    break;
                }
                default: {
                    if (sb == null) continue block5;
                    sb.append(cc);
                    continue block5;
                }
            }
            if (sb == null) {
                sb = new StringBuffer(len + 8);
                if (j > 0) {
                    sb.append(value.substring(0, j));
                }
            }
            sb.append(rep);
        }
        return sb != null ? sb.toString() : value;
    }

    public static final StringBuffer encodeText(StringBuffer sb, String value) {
        if (sb == null) {
            sb = new StringBuffer(value.length());
        }
        int len = value.length();
        block5: for (int j = 0; j < len; ++j) {
            char cc = value.charAt(j);
            switch (cc) {
                case '<': {
                    sb.append("&lt;");
                    continue block5;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block5;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block5;
                }
                default: {
                    sb.append(cc);
                }
            }
        }
        return sb;
    }

    public static final String escapeXML(String s) {
        if (s == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(s.length() + 16);
        int len = s.length();
        for (int j = 0; j < len; ++j) {
            char cc = s.charAt(j);
            String esc = XMLs.escapeXML(cc);
            if (esc != null) {
                sb.append(esc);
                continue;
            }
            sb.append(cc);
        }
        return s.length() == sb.length() ? s : sb.toString();
    }

    public static final String escapeXML(char cc) {
        switch (cc) {
            case '\"': {
                return "&#034;";
            }
            case '\'': {
                return "&#039;";
            }
            case '>': {
                return "&gt;";
            }
            case '<': {
                return "&lt;";
            }
            case '&': {
                return "&amp;";
            }
        }
        return null;
    }
}

