/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.xawk;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.TargetError;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.zkoss.idom.Element;
import org.zkoss.idom.input.SAXBuilder;
import org.zkoss.math.Calcs;
import org.zkoss.util.logging.Log;
import org.zkoss.xawk.Context;
import org.zkoss.xawk.XawkException;

public class Xawk {
    private static final Log log = Log.lookup(Xawk.class);
    private Interpreter _ip = null;
    protected final List _rules = new LinkedList();
    protected String _init;
    protected String _cleanup;
    protected String _condition;
    protected String _begin;
    protected String _end;

    public final void config(Element root) throws XawkException {
        Iterator it = root.getElements("rule").iterator();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            LinkedList<String> patterns = new LinkedList<String>();
            Iterator i2 = e.getElements("pattern").iterator();
            while (i2.hasNext()) {
                patterns.add(((Element)i2.next()).getText(true));
            }
            this.addRule(patterns, e.getElementValue("condition", true), e.getElementValue("begin", true), e.getElementValue("end", true));
        }
        this._init = root.getElementValue("init", true);
        this._cleanup = root.getElementValue("cleanup", true);
        this._condition = root.getElementValue("condition", true);
        if (this._condition != null && this._condition.length() == 0) {
            this._condition = null;
        }
        this._begin = root.getElementValue("begin", true);
        this._end = root.getElementValue("end", true);
    }

    public final void config(InputStream strm) throws XawkException, SAXException, IOException {
        try {
            this.config(new SAXBuilder(true, false, true).build(strm).getRootElement());
        }
        catch (ParserConfigurationException ex) {
            throw new XawkException(ex);
        }
    }

    public final void config(File file) throws XawkException, SAXException, IOException {
        try {
            this.config(new SAXBuilder(true, false, true).build(file).getRootElement());
        }
        catch (ParserConfigurationException ex) {
            throw new XawkException(ex);
        }
    }

    public final void config(String uri) throws XawkException, SAXException, IOException {
        try {
            this.config(new SAXBuilder(true, false, true).build(uri).getRootElement());
        }
        catch (ParserConfigurationException ex) {
            throw new XawkException(ex);
        }
    }

    public final void config(URL url) throws XawkException, SAXException, IOException {
        try {
            this.config(new SAXBuilder(true, false, true).build(url).getRootElement());
        }
        catch (ParserConfigurationException ex) {
            throw new XawkException(ex);
        }
    }

    public final void config(InputSource src) throws XawkException, SAXException, IOException {
        try {
            this.config(new SAXBuilder(true, false, true).build(src).getRootElement());
        }
        catch (ParserConfigurationException ex) {
            throw new XawkException(ex);
        }
    }

    public final void config(Reader reader) throws XawkException, SAXException, IOException {
        try {
            this.config(new SAXBuilder(true, false, true).build(reader).getRootElement());
        }
        catch (ParserConfigurationException ex) {
            throw new XawkException(ex);
        }
    }

    public final void addRule(Collection patterns, String condition, String begin, String end) {
        if (begin != null && begin.length() != 0 || end != null && end.length() != 0) {
            this._rules.add(new Rule(patterns, condition, begin, end));
        }
    }

    public final void resetRules() {
        this._rules.clear();
        this._end = null;
        this._begin = null;
        this._condition = null;
        this._cleanup = null;
        this._init = null;
    }

    public final void set(String name, Object val) throws XawkException {
        try {
            this.interpreter().set(name, val);
        }
        catch (TargetError ex) {
            Throwable t = ex.getTarget();
            throw new XawkException(t != null ? t : ex);
        }
        catch (EvalError ex) {
            throw new XawkException(ex);
        }
    }

    public final Object get(String name) throws XawkException {
        try {
            return this.interpreter().get(name);
        }
        catch (TargetError ex) {
            Throwable t = ex.getTarget();
            throw new XawkException(t != null ? t : ex);
        }
        catch (EvalError ex) {
            throw new XawkException(ex);
        }
    }

    public final void resetInterpreter() {
        this._ip = null;
    }

    public final Interpreter interpreter() {
        if (this._ip == null) {
            this._ip = new Interpreter();
            this._ip.setClassLoader(Thread.currentThread().getContextClassLoader());
        }
        return this._ip;
    }

    public final Context context() {
        try {
            return this._ip != null ? (Context)this._ip.get("the") : null;
        }
        catch (EvalError ex) {
            return null;
        }
    }

    public final Object parse(InputStream strm, boolean validate) throws XawkException, SAXException, IOException {
        try {
            return this.parse(new SAXBuilder(true, validate, true).build(strm).getRootElement());
        }
        catch (ParserConfigurationException ex) {
            throw new XawkException(ex);
        }
    }

    public final Object parse(File file, boolean validate) throws XawkException, SAXException, IOException {
        try {
            return this.parse(new SAXBuilder(true, validate, true).build(file).getRootElement());
        }
        catch (ParserConfigurationException ex) {
            throw new XawkException(ex);
        }
    }

    public final Object parse(String uri, boolean validate) throws XawkException, SAXException, IOException {
        try {
            return this.parse(new SAXBuilder(true, validate, true).build(uri).getRootElement());
        }
        catch (ParserConfigurationException ex) {
            throw new XawkException(ex);
        }
    }

    public final Object parse(URL url, boolean validate) throws XawkException, SAXException, IOException {
        try {
            return this.parse(new SAXBuilder(true, validate, true).build(url).getRootElement());
        }
        catch (ParserConfigurationException ex) {
            throw new XawkException(ex);
        }
    }

    public final Object parse(InputSource src, boolean validate) throws XawkException, SAXException, IOException {
        try {
            return this.parse(new SAXBuilder(true, validate, true).build(src).getRootElement());
        }
        catch (ParserConfigurationException ex) {
            throw new XawkException(ex);
        }
    }

    public final Object parse(Reader reader, boolean validate) throws XawkException, SAXException, IOException {
        try {
            return this.parse(new SAXBuilder(true, validate, true).build(reader).getRootElement());
        }
        catch (ParserConfigurationException ex) {
            throw new XawkException(ex);
        }
    }

    public final Object parse(Element root) throws XawkException {
        try {
            Context ctx = new Context(root, this.interpreter());
            if (log.debugable()) {
                log.debug("init: " + this._init);
            }
            if (this._init != null) {
                this.interpreter().set("the", (Object)ctx);
                this.interpreter().eval(this._init);
            }
            if (root != null) {
                this.parse(ctx);
            }
            if (log.debugable()) {
                log.debug("cleanup: " + this._cleanup);
            }
            if (this._cleanup != null) {
                this.interpreter().set("the", (Object)ctx);
                this.interpreter().eval(this._cleanup);
            }
            return this.interpreter().get("result");
        }
        catch (TargetError ex) {
            Throwable t = ex.getTarget();
            throw new XawkException(t != null ? t : ex);
        }
        catch (EvalError ex) {
            throw new XawkException(ex);
        }
    }

    private final void parse(Context ctx) throws XawkException {
        int[] ruleModes = new int[this._rules.size()];
        int j = 0;
        Iterator it = this._rules.iterator();
        while (it.hasNext()) {
            ruleModes[j++] = ((Rule)it.next()).eval(ctx, 0);
        }
        it = ctx.element.getChildren().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof Element)) continue;
            this.parse(new Context((Element)o, ctx));
        }
        j = 0;
        it = this._rules.iterator();
        while (it.hasNext()) {
            ((Rule)it.next()).eval(ctx, ruleModes[j++]);
        }
    }

    protected class Rule {
        private final Pattern[] _patterns;
        private final String _condition;
        private final String _begin;
        private final String _end;
        protected static final int BEGIN = 0;
        protected static final int END_TEST_FIRST = 1;
        protected static final int END_ALWAYS = 2;
        protected static final int END_NEVER = 3;

        protected Rule(Collection patterns, String condition, String begin, String end) {
            if (patterns == null || patterns.size() == 0) {
                this._patterns = null;
            } else {
                this._patterns = new Pattern[patterns.size()];
                int j = 0;
                Iterator it = patterns.iterator();
                while (it.hasNext()) {
                    this._patterns[j++] = Pattern.compile((String)it.next());
                }
            }
            this._condition = condition != null && condition.length() != 0 ? condition : null;
            this._begin = begin != null && begin.length() != 0 ? begin : null;
            this._end = end != null && end.length() != 0 ? end : null;
        }

        protected final int eval(Context ctx, int mode) throws XawkException {
            boolean doit;
            String script;
            String string = script = mode == 0 ? this._begin : this._end;
            if (script == null || mode == 3) {
                return 1;
            }
            boolean bl = doit = this._patterns == null || mode == 2;
            if (!doit) {
                for (int j = 0; j < this._patterns.length; ++j) {
                    if (!this._patterns[j].matcher(ctx.path).matches()) continue;
                    doit = true;
                    break;
                }
            }
            if (!doit) {
                return 3;
            }
            try {
                ctx.interpreter.set("the", (Object)ctx);
                if (mode != 2 && Xawk.this._condition != null && !Calcs.booleanValueOf(ctx.interpreter.eval(Xawk.this._condition))) {
                    return 3;
                }
                if (mode != 2 && this._condition != null && !Calcs.booleanValueOf(ctx.interpreter.eval(this._condition))) {
                    return 3;
                }
                if (log.debugable()) {
                    log.debug("path=" + ctx.path + ", text=" + ctx.text + ", script={" + script + '}');
                }
                if (mode == 0 && Xawk.this._begin != null) {
                    ctx.interpreter.eval(Xawk.this._begin);
                }
                ctx.interpreter.eval(script);
                if (mode != 0 && Xawk.this._end != null) {
                    ctx.interpreter.eval(Xawk.this._end);
                }
                return 2;
            }
            catch (TargetError ex) {
                Throwable t = ex.getTarget();
                throw new XawkException(t != null ? t : ex);
            }
            catch (EvalError ex) {
                throw new XawkException(ex);
            }
        }
    }
}

