/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Date;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.math.BigDecimals;
import org.zkoss.text.DateFormats;

public class Calcs {
    protected Calcs() {
    }

    public static boolean booleanValueOf(Object obj) {
        if (obj == null || obj == Objects.UNKNOWN) {
            return false;
        }
        if (obj instanceof String) {
            return ((String)obj).length() > 0;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Integer) {
            return (Integer)obj != 0;
        }
        if (obj instanceof Long) {
            return (Long)obj != 0L;
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).compareTo(BigDecimals.ZERO) != 0;
        }
        if (obj instanceof Double) {
            double d = (Double)obj;
            return d != 0.0 && d != Double.NaN;
        }
        if (obj instanceof Byte) {
            return (Byte)obj != 0;
        }
        if (obj instanceof Short) {
            return (Short)obj != 0;
        }
        if (obj instanceof Character) {
            return ((Character)obj).charValue() != '\u0000';
        }
        if (obj instanceof Float) {
            float f = ((Float)obj).floatValue();
            return f != 0.0f && f != Float.NaN;
        }
        if (obj instanceof BigInteger) {
            return !((BigInteger)obj).equals(BigInteger.ZERO);
        }
        return true;
    }

    public static final int intValueOf(Object obj) {
        Object val = Calcs.valueOf(obj);
        if (val instanceof Integer) {
            return (Integer)val;
        }
        if (val instanceof BigDecimal) {
            return ((BigDecimal)val).intValue();
        }
        if (val instanceof Long) {
            return ((Long)val).intValue();
        }
        if (val instanceof Double) {
            return ((Double)val).intValue();
        }
        return (int)((Date)val).getTime();
    }

    public static final long longValueOf(Object obj) {
        Object val = Calcs.valueOf(obj);
        if (val instanceof Integer) {
            return ((Integer)val).longValue();
        }
        if (val instanceof BigDecimal) {
            return ((BigDecimal)val).longValue();
        }
        if (val instanceof Long) {
            return (Long)val;
        }
        if (val instanceof Double) {
            return ((Double)val).longValue();
        }
        return ((Date)val).getTime();
    }

    public static Object valueOf(Object obj) {
        if (obj == null || obj == Objects.UNKNOWN) {
            return Objects.ZERO_INTEGER;
        }
        if (obj instanceof Integer || obj instanceof BigDecimal || obj instanceof Long || obj instanceof Date || obj instanceof Double) {
            return obj;
        }
        if (obj instanceof Byte) {
            return new Integer(((Byte)obj).intValue());
        }
        if (obj instanceof Short) {
            return new Integer(((Short)obj).intValue());
        }
        if (obj instanceof Character) {
            return new Integer(((Character)obj).charValue());
        }
        if (obj instanceof Float) {
            return new Double(((Float)obj).doubleValue());
        }
        if (obj instanceof BigInteger) {
            BigInteger v = (BigInteger)obj;
            if (v.bitCount() <= 32) {
                return new Integer(v.intValue());
            }
            if (v.bitCount() <= 64) {
                return new Long(v.longValue());
            }
            throw new UnsupportedOperationException("Not support: BigInteger's bit count > 64, " + v);
        }
        if (obj instanceof Boolean) {
            return new Integer((Boolean)obj != false ? 1 : 0);
        }
        return Calcs.valueOf(obj.toString());
    }

    public static final Object valueOf(String s) {
        if (s == null) {
            return Objects.ZERO_INTEGER;
        }
        boolean dot = false;
        boolean exp = false;
        if (!Calcs.inHexFormat(s)) {
            int k = 0;
            char[] buf = new char[s.length()];
            block8: for (int j = 0; j < buf.length; ++j) {
                char cc = s.charAt(j);
                switch (cc) {
                    case '-': {
                        if (k <= 0 || buf[k - 1] != '-') break;
                        --k;
                        continue block8;
                    }
                    case ' ': 
                    case '+': {
                        continue block8;
                    }
                    case '.': {
                        if (dot || exp) {
                            return Calcs.toDate(s);
                        }
                        dot = true;
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        if (exp) {
                            return Calcs.toDate(s);
                        }
                        exp = true;
                        break;
                    }
                    default: {
                        if (cc >= '0' && cc <= '9') break;
                        return Calcs.toDate(s);
                    }
                }
                buf[k++] = cc;
            }
            if (k == 0) {
                return Objects.ZERO_INTEGER;
            }
            if (k < buf.length) {
                s = new String(buf, 0, k);
            }
        }
        if (exp) {
            return Double.valueOf(s);
        }
        if (dot) {
            return new BigDecimal(s);
        }
        try {
            return Integer.decode(s);
        }
        catch (NumberFormatException numberFormatException) {
            return Long.decode(s);
        }
    }

    private static final boolean inHexFormat(String s) {
        int e;
        int b = Strings.skipWhitespaces(s, 0);
        if (b >= (e = Strings.skipWhitespacesBackward(s, Integer.MAX_VALUE))) {
            return false;
        }
        char cc = s.charAt(e);
        if (cc < '0' || cc > '9') {
            return false;
        }
        cc = s.charAt(b);
        if (cc == '#') {
            return true;
        }
        if (cc != '0') {
            return false;
        }
        cc = s.charAt(b + 1);
        return cc == 'x' || cc == 'X';
    }

    private static final Date toDate(String s) {
        try {
            return DateFormats.parse(s.trim());
        }
        catch (ParseException ex) {
            throw new NumberFormatException(ex.getMessage());
        }
    }

    public static final Object zero(Object obj) {
        if (obj == null || obj == Objects.UNKNOWN) {
            return Objects.ZERO_INTEGER;
        }
        if ((obj = Calcs.valueOf(obj)) instanceof Integer) {
            return Objects.ZERO_INTEGER;
        }
        if (obj instanceof Long) {
            return Objects.ZERO_LONG;
        }
        if (obj instanceof Double) {
            return Objects.ZERO_DOUBLE;
        }
        if (obj instanceof Date) {
            return Objects.ZERO_LONG;
        }
        return Objects.ZERO_BIG_DECIMAL;
    }
}

