/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ArgsUtil {
    public static final Map<String, List<Object>> parseArgs(String optionsKey, List<String> defaultKeys, Object ... args) {
        LinkedHashMap<String, List<Object>> map = new LinkedHashMap<String, List<Object>>();
        boolean allDefaultOperands = false;
        String name = null;
        ArrayList<Object> values = null;
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (allDefaultOperands) {
                String defaultKey = ArgsUtil.getDefaultKey(map, defaultKeys);
                ArgsUtil.add(map, defaultKey, arg);
                continue;
            }
            boolean isOperandValue = true;
            if (arg instanceof String) {
                String sarg = (String)arg;
                if (sarg.startsWith("--")) {
                    isOperandValue = false;
                    ArgsUtil.add(optionsKey, map, name, values);
                    if (sarg.length() == 2) {
                        allDefaultOperands = true;
                        name = null;
                        values = null;
                    } else {
                        name = sarg.substring(2);
                        values = null;
                    }
                } else if (sarg.startsWith("-") && !ArgsUtil.isDigit(sarg, 1)) {
                    isOperandValue = false;
                    ArgsUtil.add(optionsKey, map, name, values);
                    int len = sarg.length();
                    for (int j = 1; j < len; ++j) {
                        ArgsUtil.add(map, optionsKey, "" + sarg.charAt(j));
                    }
                    name = null;
                    values = null;
                }
            }
            if (!isOperandValue) continue;
            if (name == null) {
                String defaultKey = ArgsUtil.getDefaultKey(map, defaultKeys);
                ArgsUtil.add(map, defaultKey, arg);
            }
            if (values == null) {
                values = new ArrayList<Object>(2);
            }
            values.add(arg);
        }
        ArgsUtil.add(optionsKey, map, name, values);
        return map;
    }

    private static boolean isDigit(String s, int pos) {
        return s.length() > pos && Character.isDigit(s.charAt(pos));
    }

    private static String getDefaultKey(Map<String, List<Object>> map, List<String> defaultKeys) {
        for (String defaultKey : defaultKeys) {
            if (map.containsKey(defaultKey)) continue;
            return defaultKey;
        }
        return defaultKeys.get(defaultKeys.size() - 1);
    }

    private static void add(Map<String, List<Object>> map, String key, Object value) {
        List<Object> values = map.get(key);
        if (values == null) {
            values = new ArrayList<Object>(2);
            map.put(key, values);
        }
        values.add(value);
    }

    private static void add(String optionsKey, Map<String, List<Object>> map, String key, List<Object> values) {
        if (key != null) {
            if (values == null) {
                ArgsUtil.add(map, optionsKey, key);
            } else {
                List<Object> old = map.get(key);
                if (old == null) {
                    map.put(key, values);
                } else {
                    old.addAll(values);
                }
            }
        }
    }

    private ArgsUtil() {
    }
}

