/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.unix4j.convert.ValueConverter;

public class CompositeValueConverter<V>
implements ValueConverter<V> {
    private final List<ValueConverter<? extends V>> converters = new ArrayList<ValueConverter<? extends V>>();

    public CompositeValueConverter() {
    }

    public CompositeValueConverter(Collection<? extends ValueConverter<? extends V>> converters) {
        this.addAll(converters);
    }

    protected CompositeValueConverter<V> add(ValueConverter<? extends V> converter) {
        this.converters.add(converter);
        return this;
    }

    protected CompositeValueConverter<V> addAll(Collection<? extends ValueConverter<? extends V>> converters) {
        this.converters.addAll(converters);
        return this;
    }

    @Override
    public V convert(Object value) throws IllegalArgumentException {
        for (ValueConverter<V> converter : this.converters) {
            V converted = converter.convert(value);
            if (converted == null) continue;
            return converted;
        }
        return null;
    }
}

