/*
 * Decompiled with CFR 0.152.
 */
package org.unix4j.context;

import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.unix4j.context.ExecutionContext;
import org.unix4j.context.ExecutionContextFactory;
import org.unix4j.convert.ConverterRegistry;
import org.unix4j.convert.DefaultConverterRegistry;
import org.unix4j.convert.ValueConverter;
import org.unix4j.util.FileUtil;
import org.unix4j.variable.DefaultVariableContext;
import org.unix4j.variable.ExecutionContextVariableResolver;
import org.unix4j.variable.MapVariableResolver;
import org.unix4j.variable.VariableContext;

public class DefaultExecutionContext
implements ExecutionContext {
    public static final ExecutionContextFactory FACTORY = new ExecutionContextFactory(){

        @Override
        public DefaultExecutionContext createExecutionContext() {
            return new DefaultExecutionContext();
        }
    };
    private String user;
    private File userHome;
    private File tempDirectory;
    private File currentDirectory;
    private Locale locale;
    private VariableContext variableContext = null;
    private ConverterRegistry converterRegistry = null;

    public DefaultExecutionContext() {
        this.currentDirectory = null;
    }

    public DefaultExecutionContext(File currentDirectory) {
        this.currentDirectory = currentDirectory;
    }

    public void setCurrentDirectory(File currentDirectory) {
        this.currentDirectory = currentDirectory;
    }

    public void setCurrentDirectory(String currentDirectory) {
        this.setCurrentDirectory(new File(currentDirectory));
    }

    @Override
    public File getRelativeToCurrentDirectory(File file) {
        return FileUtil.toAbsoluteFile(this.getCurrentDirectory(), file);
    }

    @Override
    public File getCurrentDirectory() {
        if (this.currentDirectory == null) {
            this.currentDirectory = new File(System.getProperty("user.dir"));
        }
        return this.currentDirectory;
    }

    @Override
    public String getUser() {
        if (this.user == null) {
            this.user = System.getProperty("user.name");
        }
        return this.user;
    }

    @Override
    public File getUserHome() {
        if (this.userHome == null) {
            this.userHome = new File(System.getProperty("user.home"));
        }
        return this.userHome;
    }

    @Override
    public File getTempDirectory() {
        if (this.tempDirectory == null) {
            this.tempDirectory = new File(System.getProperty("java.io.tmpdir"));
        }
        return this.tempDirectory;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        return this.locale;
    }

    @Override
    public Map<String, String> getEnv() {
        return System.getenv();
    }

    @Override
    public Properties getSys() {
        return System.getProperties();
    }

    @Override
    public VariableContext getVariableContext() {
        if (this.variableContext == null) {
            this.variableContext = new DefaultVariableContext();
            this.variableContext.addVariableResolver(MapVariableResolver.getEnv());
            this.variableContext.addVariableResolver(MapVariableResolver.getSystemProperties());
            this.variableContext.addVariableResolver(new ExecutionContextVariableResolver(this));
        }
        return this.variableContext;
    }

    @Override
    public ConverterRegistry getConverterRegistry() {
        if (this.converterRegistry == null) {
            this.converterRegistry = new DefaultConverterRegistry();
        }
        return this.converterRegistry;
    }

    @Override
    public <V> ValueConverter<V> getValueConverterFor(Class<V> type) {
        return this.getConverterRegistry().getValueConverterFor(type);
    }
}

