/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.spring.listener;

import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.togglz.spring.util.ContextClassLoaderApplicationContextHolder;

public class TogglzApplicationContextBinderApplicationListener
implements ApplicationListener {
    private static final Logger log = LoggerFactory.getLogger(TogglzApplicationContextBinderApplicationListener.class);
    private static final ContextRefreshedEventFilter ACCEPT_ALL = t -> true;
    private final ContextRefreshedEventFilter filter;

    public TogglzApplicationContextBinderApplicationListener() {
        this(null);
    }

    public TogglzApplicationContextBinderApplicationListener(ContextRefreshedEventFilter filter) {
        this.filter = filter == null ? ACCEPT_ALL : filter;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent && this.filter.test((ContextRefreshedEvent)event)) {
            if (ContextClassLoaderApplicationContextHolder.get() != null) {
                log.warn("ApplicationContext already bound to current context class loader, releasing it first");
                ContextClassLoaderApplicationContextHolder.release();
            }
            ApplicationContext applicationContext = ((ContextRefreshedEvent)event).getApplicationContext();
            ContextClassLoaderApplicationContextHolder.bind(applicationContext);
        } else if (event instanceof ContextClosedEvent) {
            ContextClassLoaderApplicationContextHolder.release();
        }
    }

    @FunctionalInterface
    public static interface ContextRefreshedEventFilter
    extends Predicate<ContextRefreshedEvent> {
        @Override
        public boolean test(ContextRefreshedEvent var1);
    }
}

