/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.repository;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.togglz.core.Feature;

public class FeatureState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Feature feature;
    private boolean enabled;
    private String strategyId;
    private final Map<String, String> parameters = new HashMap<String, String>();

    public FeatureState(Feature feature) {
        this(feature, false);
    }

    public FeatureState(Feature feature, boolean enabled) {
        this.feature = feature;
        this.enabled = enabled;
    }

    public FeatureState copy() {
        FeatureState copy = new FeatureState(this.feature);
        copy.setEnabled(this.enabled);
        copy.setStrategyId(this.strategyId);
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            copy.setParameter(entry.getKey(), entry.getValue());
        }
        return copy;
    }

    public Feature getFeature() {
        return this.feature;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public FeatureState setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public FeatureState enable() {
        return this.setEnabled(true);
    }

    public FeatureState disable() {
        return this.setEnabled(false);
    }

    public String getStrategyId() {
        return this.strategyId;
    }

    public FeatureState setStrategyId(String strategyId) {
        this.strategyId = strategyId;
        return this;
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public FeatureState setParameter(String name, String value) {
        if (value != null) {
            this.parameters.put(name, value);
        } else {
            this.parameters.remove(name);
        }
        return this;
    }

    public Set<String> getParameterNames() {
        return this.parameters.keySet();
    }

    public Map<String, String> getParameterMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureState that = (FeatureState)o;
        if (this.enabled != that.enabled) {
            return false;
        }
        if (!this.feature.equals(that.feature)) {
            return false;
        }
        if (!Objects.equals(this.strategyId, that.strategyId)) {
            return false;
        }
        if (this.parameters.size() != that.parameters.size()) {
            return false;
        }
        return this.parameters.equals(that.parameters);
    }

    public int hashCode() {
        int result = this.feature.hashCode();
        result = 31 * result + Boolean.hashCode(this.enabled);
        result = 31 * result + (this.strategyId != null ? this.strategyId.hashCode() : 0);
        result = 31 * result + this.parameters.hashCode();
        return result;
    }

    public static FeatureState copyOf(FeatureState featureState) {
        return featureState == null ? null : featureState.copy();
    }
}

