/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring6.processor;

import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeDefinition;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.spring6.context.IThymeleafBindStatus;
import org.thymeleaf.spring6.processor.AbstractSpringFieldTagProcessor;
import org.thymeleaf.spring6.requestdata.RequestDataValueProcessorUtils;
import org.thymeleaf.spring6.util.SpringSelectedValueComparator;
import org.thymeleaf.standard.util.StandardProcessorUtils;
import org.unbescape.html.HtmlEscape;

public final class SpringInputRadioFieldTagProcessor
extends AbstractSpringFieldTagProcessor {
    public static final String RADIO_INPUT_TYPE_ATTR_VALUE = "radio";

    public SpringInputRadioFieldTagProcessor(String dialectPrefix) {
        super(dialectPrefix, "input", "type", new String[]{RADIO_INPUT_TYPE_ATTR_VALUE}, true);
    }

    @Override
    protected void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, IThymeleafBindStatus bindStatus, IElementTagStructureHandler structureHandler) {
        String name = bindStatus.getExpression();
        name = name == null ? "" : name;
        String id = this.computeId(context, tag, name, true);
        String value = tag.getAttributeValue(this.valueAttributeDefinition.getAttributeName());
        if (value == null) {
            throw new TemplateProcessingException("Attribute \"value\" is required in \"input(radio)\" tags");
        }
        boolean checked = SpringSelectedValueComparator.isSelected(bindStatus, HtmlEscape.unescapeHtml((String)value));
        StandardProcessorUtils.setAttribute((IElementTagStructureHandler)structureHandler, (AttributeDefinition)this.idAttributeDefinition, (String)"id", (String)id);
        StandardProcessorUtils.setAttribute((IElementTagStructureHandler)structureHandler, (AttributeDefinition)this.nameAttributeDefinition, (String)"name", (String)name);
        StandardProcessorUtils.setAttribute((IElementTagStructureHandler)structureHandler, (AttributeDefinition)this.valueAttributeDefinition, (String)"value", (String)RequestDataValueProcessorUtils.processFormFieldValue(context, name, value, RADIO_INPUT_TYPE_ATTR_VALUE));
        if (checked) {
            StandardProcessorUtils.setAttribute((IElementTagStructureHandler)structureHandler, (AttributeDefinition)this.checkedAttributeDefinition, (String)"checked", (String)"checked");
        } else {
            structureHandler.removeAttribute(this.checkedAttributeDefinition.getAttributeName());
        }
    }
}

