/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.client;

import java.net.URI;
import java.security.Principal;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpHeaders;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.Assert;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.sockjs.SockJsTransportFailureException;
import org.springframework.web.socket.sockjs.client.SockJsUrlInfo;
import org.springframework.web.socket.sockjs.client.Transport;
import org.springframework.web.socket.sockjs.client.TransportRequest;
import org.springframework.web.socket.sockjs.frame.SockJsMessageCodec;
import org.springframework.web.socket.sockjs.transport.TransportType;

class DefaultTransportRequest
implements TransportRequest {
    private static final Log logger = LogFactory.getLog(DefaultTransportRequest.class);
    private final SockJsUrlInfo sockJsUrlInfo;
    private final HttpHeaders handshakeHeaders;
    private final HttpHeaders httpRequestHeaders;
    private final Transport transport;
    private final TransportType serverTransportType;
    private final SockJsMessageCodec codec;
    private @Nullable Principal user;
    private long timeoutValue;
    private @Nullable TaskScheduler timeoutScheduler;
    private final List<Runnable> timeoutTasks = new ArrayList<Runnable>();
    private @Nullable DefaultTransportRequest fallbackRequest;

    public DefaultTransportRequest(SockJsUrlInfo sockJsUrlInfo, @Nullable HttpHeaders handshakeHeaders, @Nullable HttpHeaders httpRequestHeaders, Transport transport, TransportType serverTransportType, SockJsMessageCodec codec) {
        Assert.notNull((Object)sockJsUrlInfo, (String)"SockJsUrlInfo is required");
        Assert.notNull((Object)transport, (String)"Transport is required");
        Assert.notNull((Object)((Object)serverTransportType), (String)"TransportType is required");
        Assert.notNull((Object)codec, (String)"SockJsMessageCodec is required");
        this.sockJsUrlInfo = sockJsUrlInfo;
        this.handshakeHeaders = handshakeHeaders != null ? handshakeHeaders : new HttpHeaders();
        this.httpRequestHeaders = httpRequestHeaders != null ? httpRequestHeaders : new HttpHeaders();
        this.transport = transport;
        this.serverTransportType = serverTransportType;
        this.codec = codec;
    }

    @Override
    public SockJsUrlInfo getSockJsUrlInfo() {
        return this.sockJsUrlInfo;
    }

    @Override
    public HttpHeaders getHandshakeHeaders() {
        return this.handshakeHeaders;
    }

    @Override
    public HttpHeaders getHttpRequestHeaders() {
        return this.httpRequestHeaders;
    }

    @Override
    public URI getTransportUrl() {
        return this.sockJsUrlInfo.getTransportUrl(this.serverTransportType);
    }

    public void setUser(Principal user) {
        this.user = user;
    }

    @Override
    public @Nullable Principal getUser() {
        return this.user;
    }

    @Override
    public SockJsMessageCodec getMessageCodec() {
        return this.codec;
    }

    public void setTimeoutValue(long timeoutValue) {
        this.timeoutValue = timeoutValue;
    }

    public void setTimeoutScheduler(TaskScheduler scheduler) {
        this.timeoutScheduler = scheduler;
    }

    @Override
    public void addTimeoutTask(Runnable runnable) {
        this.timeoutTasks.add(runnable);
    }

    public void setFallbackRequest(DefaultTransportRequest fallbackRequest) {
        this.fallbackRequest = fallbackRequest;
    }

    public void connect(WebSocketHandler handler, CompletableFuture<WebSocketSession> future) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Starting " + String.valueOf(this)));
        }
        CompletableConnectCallback connectCallback = new CompletableConnectCallback(handler, future);
        this.scheduleConnectTimeoutTask(connectCallback);
        this.transport.connectAsync(this, handler).whenComplete((BiConsumer)connectCallback);
    }

    private void scheduleConnectTimeoutTask(CompletableConnectCallback connectHandler) {
        if (this.timeoutScheduler != null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Scheduling connect to time out after " + this.timeoutValue + " ms."));
            }
            Instant timeoutDate = Instant.now().plus(this.timeoutValue, ChronoUnit.MILLIS);
            this.timeoutScheduler.schedule((Runnable)connectHandler, timeoutDate);
        } else if (logger.isTraceEnabled()) {
            logger.trace((Object)"Connect timeout task not scheduled (no TaskScheduler configured).");
        }
    }

    public String toString() {
        return "TransportRequest[url=" + String.valueOf(this.getTransportUrl()) + "]";
    }

    private class CompletableConnectCallback
    implements Runnable,
    BiConsumer<WebSocketSession, Throwable> {
        private final WebSocketHandler handler;
        private final CompletableFuture<WebSocketSession> future;
        private final AtomicBoolean handled = new AtomicBoolean();

        public CompletableConnectCallback(WebSocketHandler handler, CompletableFuture<WebSocketSession> future) {
            this.handler = handler;
            this.future = future;
        }

        @Override
        public void accept(@Nullable WebSocketSession session, @Nullable Throwable throwable) {
            if (session != null) {
                if (this.handled.compareAndSet(false, true)) {
                    this.future.complete(session);
                } else if (logger.isErrorEnabled()) {
                    logger.error((Object)("Connect success/failure already handled for " + String.valueOf(DefaultTransportRequest.this)));
                }
            } else if (throwable != null) {
                this.handleFailure(throwable, false);
            }
        }

        @Override
        public void run() {
            this.handleFailure(null, true);
        }

        private void handleFailure(@Nullable Throwable ex, boolean isTimeoutFailure) {
            if (this.handled.compareAndSet(false, true)) {
                if (isTimeoutFailure) {
                    String message = "Connect timed out for " + String.valueOf(DefaultTransportRequest.this);
                    logger.error((Object)message);
                    ex = new SockJsTransportFailureException(message, DefaultTransportRequest.this.getSockJsUrlInfo().getSessionId(), (Throwable)ex);
                }
                if (DefaultTransportRequest.this.fallbackRequest != null) {
                    logger.error((Object)(String.valueOf(DefaultTransportRequest.this) + " failed. Falling back on next transport."), ex);
                    DefaultTransportRequest.this.fallbackRequest.connect(this.handler, this.future);
                } else {
                    logger.error((Object)("No more fallback transports after " + String.valueOf(DefaultTransportRequest.this)), ex);
                    if (ex != null) {
                        this.future.completeExceptionally((Throwable)ex);
                    }
                }
                if (isTimeoutFailure) {
                    try {
                        for (Runnable runnable : DefaultTransportRequest.this.timeoutTasks) {
                            runnable.run();
                        }
                    }
                    catch (Throwable ex2) {
                        logger.error((Object)("Transport failed to run timeout tasks for " + String.valueOf(DefaultTransportRequest.this)), ex2);
                    }
                }
            } else {
                logger.error((Object)("Connect success/failure events already took place for " + String.valueOf(DefaultTransportRequest.this) + ". Ignoring this additional failure event."), ex);
            }
        }
    }
}

