/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.servlet.AsyncContext;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.connector.CoyoteInputStream;
import org.apache.catalina.connector.CoyoteOutputStream;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServletHttpHandlerAdapter;
import org.springframework.http.server.reactive.ServletServerHttpRequest;
import org.springframework.http.server.reactive.ServletServerHttpResponse;

@WebServlet(asyncSupported=true)
public class TomcatHttpHandlerAdapter
extends ServletHttpHandlerAdapter {
    public TomcatHttpHandlerAdapter(HttpHandler httpHandler) {
        super(httpHandler);
    }

    @Override
    protected ServerHttpRequest createRequest(HttpServletRequest request, AsyncContext cxt) throws IOException {
        return new TomcatServerHttpRequest(request, cxt, this.getDataBufferFactory(), this.getBufferSize());
    }

    @Override
    protected ServerHttpResponse createResponse(HttpServletResponse response, AsyncContext cxt) throws IOException {
        return new TomcatServerHttpResponse(response, cxt, this.getDataBufferFactory(), this.getBufferSize());
    }

    private static final class TomcatServerHttpResponse
    extends ServletServerHttpResponse {
        public TomcatServerHttpResponse(HttpServletResponse response, AsyncContext context, DataBufferFactory factory, int bufferSize) throws IOException {
            super(response, context, factory, bufferSize);
        }

        @Override
        protected int writeToOutputStream(DataBuffer dataBuffer) throws IOException {
            ByteBuffer input = dataBuffer.asByteBuffer();
            int len = input.remaining();
            ((CoyoteOutputStream)this.getServletResponse().getOutputStream()).write(input);
            return len;
        }
    }

    private final class TomcatServerHttpRequest
    extends ServletServerHttpRequest {
        public TomcatServerHttpRequest(HttpServletRequest request, AsyncContext context, DataBufferFactory factory, int bufferSize) throws IOException {
            super(request, context, factory, bufferSize);
        }

        @Override
        protected DataBuffer readFromInputStream() throws IOException {
            DataBuffer buffer = TomcatHttpHandlerAdapter.this.getDataBufferFactory().allocateBuffer(TomcatHttpHandlerAdapter.this.getBufferSize());
            ByteBuffer byteBuffer = buffer.asByteBuffer();
            byteBuffer.limit(byteBuffer.capacity());
            int read = ((CoyoteInputStream)this.getServletRequest().getInputStream()).read(byteBuffer);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("read:" + read));
            }
            if (read > 0) {
                return TomcatHttpHandlerAdapter.this.getDataBufferFactory().wrap(byteBuffer);
            }
            return null;
        }
    }
}

