/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec;

import java.util.Collections;
import java.util.List;
import org.springframework.core.codec.Encoder;
import org.springframework.http.codec.AbstractCodecConfigurer;
import org.springframework.http.codec.FormHttpMessageReader;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.http.codec.ServerSentEventHttpMessageWriter;
import org.springframework.http.codec.multipart.MultipartHttpMessageReader;
import org.springframework.http.codec.multipart.SynchronossPartHttpMessageReader;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

class DefaultServerCodecConfigurer
extends AbstractCodecConfigurer
implements ServerCodecConfigurer {
    static final boolean synchronossMultipartPresent = ClassUtils.isPresent((String)"org.synchronoss.cloud.nio.multipart.NioMultipartParser", (ClassLoader)DefaultServerCodecConfigurer.class.getClassLoader());

    public DefaultServerCodecConfigurer() {
        super(new ServerDefaultCodecsImpl());
    }

    @Override
    public ServerCodecConfigurer.ServerDefaultCodecs defaultCodecs() {
        return (ServerCodecConfigurer.ServerDefaultCodecs)super.defaultCodecs();
    }

    private static class ServerDefaultCodecsImpl
    extends AbstractCodecConfigurer.AbstractDefaultCodecs
    implements ServerCodecConfigurer.ServerDefaultCodecs {
        @Nullable
        private Encoder<?> sseEncoder;

        private ServerDefaultCodecsImpl() {
        }

        @Override
        public void serverSentEventEncoder(Encoder<?> encoder) {
            this.sseEncoder = encoder;
        }

        @Override
        protected boolean splitTextOnNewLine() {
            return true;
        }

        @Override
        public List<HttpMessageReader<?>> getTypedReaders() {
            if (!this.shouldRegisterDefaults()) {
                return Collections.emptyList();
            }
            List<HttpMessageReader<?>> result = super.getTypedReaders();
            result.add(new FormHttpMessageReader());
            if (synchronossMultipartPresent) {
                SynchronossPartHttpMessageReader partReader = new SynchronossPartHttpMessageReader();
                result.add(partReader);
                result.add(new MultipartHttpMessageReader(partReader));
            }
            return result;
        }

        @Override
        public List<HttpMessageWriter<?>> getObjectWriters() {
            if (!this.shouldRegisterDefaults()) {
                return Collections.emptyList();
            }
            List<HttpMessageWriter<?>> result = super.getObjectWriters();
            result.add(new ServerSentEventHttpMessageWriter(this.getSseEncoder()));
            return result;
        }

        @Nullable
        private Encoder<?> getSseEncoder() {
            if (this.sseEncoder != null) {
                return this.sseEncoder;
            }
            return AbstractCodecConfigurer.jackson2Present ? this.jackson2JsonEncoder() : null;
        }
    }
}

