/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class Jackson2ObjectMapperFactoryBean
implements FactoryBean<ObjectMapper>,
InitializingBean {
    private ObjectMapper objectMapper;
    private Map<Object, Boolean> features = new HashMap<Object, Boolean>();
    private final List<Module> modules = new ArrayList<Module>();
    private DateFormat dateFormat;
    private AnnotationIntrospector annotationIntrospector;
    private final Map<Class<?>, JsonSerializer<?>> serializers = new LinkedHashMap();
    private final Map<Class<?>, JsonDeserializer<?>> deserializers = new LinkedHashMap();
    private JsonInclude.Include serializationInclusion;

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setSimpleDateFormat(String format) {
        this.dateFormat = new SimpleDateFormat(format);
    }

    public void setAnnotationIntrospector(AnnotationIntrospector annotationIntrospector) {
        this.annotationIntrospector = annotationIntrospector;
    }

    public void setSerializers(JsonSerializer<?> ... serializers) {
        if (serializers != null) {
            for (JsonSerializer<?> serializer : serializers) {
                Class handledType = serializer.handledType();
                Assert.isTrue((handledType != null && handledType != Object.class ? 1 : 0) != 0, (String)("Unknown handled type in " + serializer.getClass().getName()));
                this.serializers.put(serializer.handledType(), serializer);
            }
        }
    }

    public void setSerializersByType(Map<Class<?>, JsonSerializer<?>> serializers) {
        if (serializers != null) {
            this.serializers.putAll(serializers);
        }
    }

    public void setDeserializersByType(Map<Class<?>, JsonDeserializer<?>> deserializers) {
        if (deserializers != null) {
            this.deserializers.putAll(deserializers);
        }
    }

    public void setAutoDetectFields(boolean autoDetectFields) {
        this.features.put(MapperFeature.AUTO_DETECT_FIELDS, autoDetectFields);
    }

    public void setAutoDetectGettersSetters(boolean autoDetectGettersSetters) {
        this.features.put(MapperFeature.AUTO_DETECT_GETTERS, autoDetectGettersSetters);
        this.features.put(MapperFeature.AUTO_DETECT_SETTERS, autoDetectGettersSetters);
    }

    public void setFailOnEmptyBeans(boolean failOnEmptyBeans) {
        this.features.put(SerializationFeature.FAIL_ON_EMPTY_BEANS, failOnEmptyBeans);
    }

    public void setIndentOutput(boolean indentOutput) {
        this.features.put(SerializationFeature.INDENT_OUTPUT, indentOutput);
    }

    public void setFeaturesToEnable(Object ... featuresToEnable) {
        if (featuresToEnable != null) {
            for (Object feature : featuresToEnable) {
                this.features.put(feature, Boolean.TRUE);
            }
        }
    }

    public void setFeaturesToDisable(Object ... featuresToDisable) {
        if (featuresToDisable != null) {
            for (Object feature : featuresToDisable) {
                this.features.put(feature, Boolean.FALSE);
            }
        }
    }

    public void setSerializationInclusion(JsonInclude.Include serializationInclusion) {
        this.serializationInclusion = serializationInclusion;
    }

    public void setModules(List<Module> modules) {
        if (modules != null) {
            this.modules.addAll(modules);
        }
    }

    public void afterPropertiesSet() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
        }
        if (this.dateFormat != null) {
            this.objectMapper.setDateFormat(this.dateFormat);
        }
        if (!this.serializers.isEmpty() || !this.deserializers.isEmpty()) {
            SimpleModule module = new SimpleModule();
            this.addSerializers(module);
            this.addDeserializers(module);
            this.objectMapper.registerModule((Module)module);
        }
        if (this.annotationIntrospector != null) {
            this.objectMapper.setAnnotationIntrospector(this.annotationIntrospector);
        }
        for (Object feature : this.features.keySet()) {
            this.configureFeature(feature, this.features.get(feature));
        }
        if (this.serializationInclusion != null) {
            this.objectMapper.setSerializationInclusion(this.serializationInclusion);
        }
        if (!this.modules.isEmpty()) {
            this.objectMapper.registerModules(this.modules);
        }
    }

    private <T> void addSerializers(SimpleModule module) {
        for (Class<?> type : this.serializers.keySet()) {
            module.addSerializer(type, this.serializers.get(type));
        }
    }

    private <T> void addDeserializers(SimpleModule module) {
        for (Class<?> type : this.deserializers.keySet()) {
            module.addDeserializer(type, this.deserializers.get(type));
        }
    }

    private void configureFeature(Object feature, boolean enabled) {
        if (feature instanceof JsonParser.Feature) {
            this.objectMapper.configure((JsonParser.Feature)feature, enabled);
        } else if (feature instanceof JsonGenerator.Feature) {
            this.objectMapper.configure((JsonGenerator.Feature)feature, enabled);
        } else if (feature instanceof SerializationFeature) {
            this.objectMapper.configure((SerializationFeature)feature, enabled);
        } else if (feature instanceof DeserializationFeature) {
            this.objectMapper.configure((DeserializationFeature)feature, enabled);
        } else if (feature instanceof MapperFeature) {
            this.objectMapper.configure((MapperFeature)feature, enabled);
        } else {
            throw new FatalBeanException("Unknown feature class " + feature.getClass().getName());
        }
    }

    public ObjectMapper getObject() {
        return this.objectMapper;
    }

    public Class<?> getObjectType() {
        return ObjectMapper.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

