/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate5;

import javax.persistence.PersistenceException;
import org.hibernate.HibernateException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.orm.hibernate5.SessionFactoryUtils;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;

public class HibernateExceptionTranslator
implements PersistenceExceptionTranslator {
    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        if (ex instanceof HibernateException) {
            return this.convertHibernateAccessException((HibernateException)((Object)ex));
        }
        if (ex instanceof PersistenceException && ex.getCause() instanceof HibernateException) {
            return this.convertHibernateAccessException((HibernateException)ex.getCause());
        }
        return EntityManagerFactoryUtils.convertJpaAccessExceptionIfPossible(ex);
    }

    protected DataAccessException convertHibernateAccessException(HibernateException ex) {
        return SessionFactoryUtils.convertHibernateAccessException(ex);
    }
}

