/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.lang.reflect.Method;
import org.springframework.beans.PropertyDescriptorUtils;

class SimpleIndexedPropertyDescriptor
extends IndexedPropertyDescriptor {
    private Method readMethod;
    private Method writeMethod;
    private Class<?> propertyType;
    private Method indexedReadMethod;
    private Method indexedWriteMethod;
    private Class<?> indexedPropertyType;
    private Class<?> propertyEditorClass;

    public SimpleIndexedPropertyDescriptor(IndexedPropertyDescriptor original) throws IntrospectionException {
        this(original.getName(), original.getReadMethod(), original.getWriteMethod(), original.getIndexedReadMethod(), original.getIndexedWriteMethod());
        PropertyDescriptorUtils.copyNonMethodProperties(original, this);
    }

    public SimpleIndexedPropertyDescriptor(String propertyName, Method readMethod, Method writeMethod, Method indexedReadMethod, Method indexedWriteMethod) throws IntrospectionException {
        super(propertyName, null, null, null, null);
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
        this.propertyType = PropertyDescriptorUtils.findPropertyType(readMethod, writeMethod);
        this.indexedReadMethod = indexedReadMethod;
        this.indexedWriteMethod = indexedWriteMethod;
        this.indexedPropertyType = PropertyDescriptorUtils.findIndexedPropertyType(propertyName, this.propertyType, indexedReadMethod, indexedWriteMethod);
    }

    @Override
    public Method getReadMethod() {
        return this.readMethod;
    }

    @Override
    public void setReadMethod(Method readMethod) {
        this.readMethod = readMethod;
    }

    @Override
    public Method getWriteMethod() {
        return this.writeMethod;
    }

    @Override
    public void setWriteMethod(Method writeMethod) {
        this.writeMethod = writeMethod;
    }

    @Override
    public Class<?> getPropertyType() {
        if (this.propertyType == null) {
            try {
                this.propertyType = PropertyDescriptorUtils.findPropertyType(this.readMethod, this.writeMethod);
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
        return this.propertyType;
    }

    @Override
    public Method getIndexedReadMethod() {
        return this.indexedReadMethod;
    }

    @Override
    public void setIndexedReadMethod(Method indexedReadMethod) throws IntrospectionException {
        this.indexedReadMethod = indexedReadMethod;
    }

    @Override
    public Method getIndexedWriteMethod() {
        return this.indexedWriteMethod;
    }

    @Override
    public void setIndexedWriteMethod(Method indexedWriteMethod) throws IntrospectionException {
        this.indexedWriteMethod = indexedWriteMethod;
    }

    @Override
    public Class<?> getIndexedPropertyType() {
        if (this.indexedPropertyType == null) {
            try {
                this.indexedPropertyType = PropertyDescriptorUtils.findIndexedPropertyType(this.getName(), this.getPropertyType(), this.indexedReadMethod, this.indexedWriteMethod);
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
        return this.indexedPropertyType;
    }

    @Override
    public Class<?> getPropertyEditorClass() {
        return this.propertyEditorClass;
    }

    @Override
    public void setPropertyEditorClass(Class<?> propertyEditorClass) {
        this.propertyEditorClass = propertyEditorClass;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof IndexedPropertyDescriptor) {
            IndexedPropertyDescriptor other = (IndexedPropertyDescriptor)obj;
            if (!PropertyDescriptorUtils.compareMethods(this.getIndexedReadMethod(), other.getIndexedReadMethod())) {
                return false;
            }
            if (!PropertyDescriptorUtils.compareMethods(this.getIndexedWriteMethod(), other.getIndexedWriteMethod())) {
                return false;
            }
            if (this.getIndexedPropertyType() != other.getIndexedPropertyType()) {
                return false;
            }
            return PropertyDescriptorUtils.equals(this, obj);
        }
        return false;
    }

    @Override
    public String toString() {
        return String.format("%s[name=%s, propertyType=%s, indexedPropertyType=%s, readMethod=%s, writeMethod=%s, indexedReadMethod=%s, indexedWriteMethod=%s]", this.getClass().getSimpleName(), this.getName(), this.getPropertyType(), this.getIndexedPropertyType(), this.readMethod, this.writeMethod, this.indexedReadMethod, this.indexedWriteMethod);
    }
}

