/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Properties;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.util.StringUtils;

public class ServiceLocatorFactoryBean
implements FactoryBean,
BeanFactoryAware,
InitializingBean {
    private Class serviceLocatorInterface;
    private Constructor serviceLocatorExceptionConstructor;
    private Properties serviceMappings;
    private ListableBeanFactory beanFactory;
    private Object proxy;
    static /* synthetic */ Class class$java$lang$Exception;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$lang$Object;

    public void setServiceLocatorInterface(Class interfaceType) {
        this.serviceLocatorInterface = interfaceType;
    }

    public void setServiceLocatorExceptionClass(Class serviceLocatorExceptionClass) {
        if (serviceLocatorExceptionClass != null && !(class$java$lang$Exception == null ? (class$java$lang$Exception = ServiceLocatorFactoryBean.class$("java.lang.Exception")) : class$java$lang$Exception).isAssignableFrom(serviceLocatorExceptionClass)) {
            throw new IllegalArgumentException("serviceLocatorException [" + serviceLocatorExceptionClass.getName() + "] is not a subclass of Exception");
        }
        this.serviceLocatorExceptionConstructor = this.determineServiceLocatorExceptionConstructor(serviceLocatorExceptionClass);
    }

    public void setServiceMappings(Properties serviceMappings) {
        this.serviceMappings = serviceMappings;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (!(beanFactory instanceof ListableBeanFactory)) {
            throw new FatalBeanException("ServiceLocatorFactoryBean needs to run in a BeanFactory that is a ListableBeanFactory");
        }
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }

    public void afterPropertiesSet() {
        if (this.serviceLocatorInterface == null) {
            throw new IllegalArgumentException("serviceLocatorInterface is required");
        }
        this.proxy = Proxy.newProxyInstance(this.serviceLocatorInterface.getClassLoader(), new Class[]{this.serviceLocatorInterface}, (InvocationHandler)new ServiceLocatorInvocationHandler());
    }

    protected Constructor determineServiceLocatorExceptionConstructor(Class exceptionClass) {
        try {
            return exceptionClass.getConstructor(class$java$lang$String == null ? (class$java$lang$String = ServiceLocatorFactoryBean.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Throwable == null ? (class$java$lang$Throwable = ServiceLocatorFactoryBean.class$("java.lang.Throwable")) : class$java$lang$Throwable);
        }
        catch (NoSuchMethodException ex) {
            try {
                return exceptionClass.getConstructor(class$java$lang$Throwable == null ? (class$java$lang$Throwable = ServiceLocatorFactoryBean.class$("java.lang.Throwable")) : class$java$lang$Throwable);
            }
            catch (NoSuchMethodException ex2) {
                try {
                    return exceptionClass.getConstructor(class$java$lang$String == null ? (class$java$lang$String = ServiceLocatorFactoryBean.class$("java.lang.String")) : class$java$lang$String);
                }
                catch (NoSuchMethodException ex3) {
                    throw new IllegalArgumentException("serviceLocatorException [" + exceptionClass.getName() + "] neither has a (String, Throwable) constructor nor a (String) constructor");
                }
            }
        }
    }

    protected Exception createServiceLocatorException(Constructor exceptionConstructor, BeansException cause) {
        Class<?>[] paramTypes = exceptionConstructor.getParameterTypes();
        Object[] args = new Object[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            if (paramTypes[i].equals(class$java$lang$String == null ? ServiceLocatorFactoryBean.class$("java.lang.String") : class$java$lang$String)) {
                args[i] = cause.getMessage();
                continue;
            }
            if (!paramTypes[i].isInstance((Object)cause)) continue;
            args[i] = cause;
        }
        return (Exception)BeanUtils.instantiateClass(exceptionConstructor, args);
    }

    public Object getObject() {
        return this.proxy;
    }

    public Class getObjectType() {
        return this.serviceLocatorInterface;
    }

    public boolean isSingleton() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ServiceLocatorInvocationHandler
    implements InvocationHandler {
        private ServiceLocatorInvocationHandler() {
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object service = (class$java$lang$Object == null ? (class$java$lang$Object = ServiceLocatorFactoryBean.class$("java.lang.Object")) : class$java$lang$Object).equals(method.getDeclaringClass()) ? this.invokeStandardObjectMethod(method, args) : this.invokeServiceLocatorMethod(method, args);
            return service;
        }

        public String toString() {
            return "Service locator: " + ServiceLocatorFactoryBean.this.serviceLocatorInterface.getName();
        }

        private Object invokeServiceLocatorMethod(Method method, Object[] args) throws Exception {
            Class serviceLocatorMethodReturnType = this.getServiceLocatorMethodReturnType(method);
            try {
                String beanName = this.tryGetBeanName(args);
                if (StringUtils.hasLength((String)beanName)) {
                    return ServiceLocatorFactoryBean.this.beanFactory.getBean(beanName, serviceLocatorMethodReturnType);
                }
                return BeanFactoryUtils.beanOfTypeIncludingAncestors(ServiceLocatorFactoryBean.this.beanFactory, serviceLocatorMethodReturnType);
            }
            catch (BeansException ex) {
                if (ServiceLocatorFactoryBean.this.serviceLocatorExceptionConstructor != null) {
                    throw ServiceLocatorFactoryBean.this.createServiceLocatorException(ServiceLocatorFactoryBean.this.serviceLocatorExceptionConstructor, ex);
                }
                throw ex;
            }
        }

        private String tryGetBeanName(Object[] args) {
            String mappedName;
            String beanName = "";
            if (args != null && args.length == 1 && args[0] != null) {
                beanName = args[0].toString();
            }
            if (ServiceLocatorFactoryBean.this.serviceMappings != null && (mappedName = ServiceLocatorFactoryBean.this.serviceMappings.getProperty(beanName)) != null) {
                beanName = mappedName;
            }
            return beanName;
        }

        private Class getServiceLocatorMethodReturnType(Method method) throws NoSuchMethodException {
            Class<?>[] paramTypes = method.getParameterTypes();
            Method interfaceMethod = ServiceLocatorFactoryBean.this.serviceLocatorInterface.getMethod(method.getName(), paramTypes);
            Class<?> serviceLocatorReturnType = interfaceMethod.getReturnType();
            if (paramTypes.length > 1 || Void.TYPE.equals(serviceLocatorReturnType)) {
                throw new UnsupportedOperationException("May only call methods with signature '<type> xxx()' or '<type> xxx(<idtype> id)' on factory interface, but tried to call: " + interfaceMethod);
            }
            return serviceLocatorReturnType;
        }

        private Object invokeStandardObjectMethod(Method method, Object[] args) throws Throwable {
            try {
                return method.invoke((Object)this, args);
            }
            catch (InvocationTargetException invEx) {
                throw invEx.getTargetException();
            }
        }
    }
}

