/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.session;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.security.web.authentication.session.AbstractSessionFixationProtectionStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionFixationProtectionStrategy
extends AbstractSessionFixationProtectionStrategy {
    boolean migrateSessionAttributes = true;
    private List<String> retainedAttributes = null;

    protected Map<String, Object> extractAttributes(HttpSession session) {
        return this.createMigratedAttributeMap(session);
    }

    @Override
    final HttpSession applySessionFixation(HttpServletRequest request) {
        HttpSession session = request.getSession();
        String originalSessionId = session.getId();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Invalidating session with Id '" + originalSessionId + "' " + (this.migrateSessionAttributes ? "and" : "without") + " migrating attributes."));
        }
        Map<String, Object> attributesToMigrate = this.extractAttributes(session);
        session.invalidate();
        session = request.getSession(true);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Started new session: " + session.getId()));
        }
        this.transferAttributes(attributesToMigrate, session);
        return session;
    }

    void transferAttributes(Map<String, Object> attributes, HttpSession newSession) {
        if (attributes != null) {
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                newSession.setAttribute(entry.getKey(), entry.getValue());
            }
        }
    }

    private HashMap<String, Object> createMigratedAttributeMap(HttpSession session) {
        HashMap<String, Object> attributesToMigrate;
        block3: {
            block2: {
                attributesToMigrate = null;
                if (!this.migrateSessionAttributes && this.retainedAttributes != null) break block2;
                attributesToMigrate = new HashMap<String, Object>();
                Enumeration enumer = session.getAttributeNames();
                while (enumer.hasMoreElements()) {
                    String key = (String)enumer.nextElement();
                    if (!this.migrateSessionAttributes && !key.startsWith("SPRING_SECURITY_")) continue;
                    attributesToMigrate.put(key, session.getAttribute(key));
                }
                break block3;
            }
            if (this.retainedAttributes.isEmpty()) break block3;
            attributesToMigrate = new HashMap();
            for (String name : this.retainedAttributes) {
                Object value = session.getAttribute(name);
                if (value == null) continue;
                attributesToMigrate.put(name, value);
            }
        }
        return attributesToMigrate;
    }

    public void setMigrateSessionAttributes(boolean migrateSessionAttributes) {
        this.migrateSessionAttributes = migrateSessionAttributes;
    }
}

