/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

class JwtDecoderProviderConfigurationUtils {
    private static final String OIDC_METADATA_PATH = "/.well-known/openid-configuration";
    private static final String OAUTH_METADATA_PATH = "/.well-known/oauth-authorization-server";
    private static final RestTemplate rest = new RestTemplate();
    private static final ParameterizedTypeReference<Map<String, Object>> typeReference = new ParameterizedTypeReference<Map<String, Object>>(){};

    JwtDecoderProviderConfigurationUtils() {
    }

    static Map<String, Object> getConfigurationForOidcIssuerLocation(String oidcIssuerLocation) {
        return JwtDecoderProviderConfigurationUtils.getConfiguration(oidcIssuerLocation, JwtDecoderProviderConfigurationUtils.oidc(URI.create(oidcIssuerLocation)));
    }

    static Map<String, Object> getConfigurationForIssuerLocation(String issuer) {
        URI uri = URI.create(issuer);
        return JwtDecoderProviderConfigurationUtils.getConfiguration(issuer, JwtDecoderProviderConfigurationUtils.oidc(uri), JwtDecoderProviderConfigurationUtils.oidcRfc8414(uri), JwtDecoderProviderConfigurationUtils.oauth(uri));
    }

    static void validateIssuer(Map<String, Object> configuration, String issuer) {
        String metadataIssuer = "(unavailable)";
        if (configuration.containsKey("issuer")) {
            metadataIssuer = configuration.get("issuer").toString();
        }
        if (!issuer.equals(metadataIssuer)) {
            throw new IllegalStateException("The Issuer \"" + metadataIssuer + "\" provided in the configuration did not match the requested issuer \"" + issuer + "\"");
        }
    }

    private static Map<String, Object> getConfiguration(String issuer, URI ... uris) {
        String errorMessage = "Unable to resolve the Configuration with the provided Issuer of \"" + issuer + "\"";
        for (URI uri : uris) {
            try {
                RequestEntity request = RequestEntity.get((URI)uri).build();
                ResponseEntity response = rest.exchange(request, typeReference);
                Map configuration = (Map)response.getBody();
                if (configuration.get("jwks_uri") == null) {
                    throw new IllegalArgumentException("The public JWK set URI must not be null");
                }
                return configuration;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (RuntimeException e) {
                if (e instanceof HttpClientErrorException && ((HttpClientErrorException)e).getStatusCode().is4xxClientError()) continue;
                throw new IllegalArgumentException(errorMessage, e);
            }
        }
        throw new IllegalArgumentException(errorMessage);
    }

    private static URI oidc(URI issuer) {
        return UriComponentsBuilder.fromUri((URI)issuer).replacePath(issuer.getPath() + OIDC_METADATA_PATH).build(Collections.emptyMap());
    }

    private static URI oidcRfc8414(URI issuer) {
        return UriComponentsBuilder.fromUri((URI)issuer).replacePath(OIDC_METADATA_PATH + issuer.getPath()).build(Collections.emptyMap());
    }

    private static URI oauth(URI issuer) {
        return UriComponentsBuilder.fromUri((URI)issuer).replacePath(OAUTH_METADATA_PATH + issuer.getPath()).build(Collections.emptyMap());
    }
}

