/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.client.endpoint;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.security.oauth2.client.endpoint.AbstractOAuth2AuthorizationGrantRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;

public final class DefaultOAuth2TokenRequestHeadersConverter<T extends AbstractOAuth2AuthorizationGrantRequest>
implements Converter<T, HttpHeaders> {
    private List<MediaType> accept = List.of(MediaType.APPLICATION_JSON);
    private MediaType contentType = MediaType.APPLICATION_FORM_URLENCODED;
    private boolean encodeClientCredentials = true;

    public HttpHeaders convert(T grantRequest) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(this.accept);
        headers.setContentType(this.contentType);
        ClientRegistration clientRegistration = ((AbstractOAuth2AuthorizationGrantRequest)grantRequest).getClientRegistration();
        if (ClientAuthenticationMethod.CLIENT_SECRET_BASIC.equals((Object)clientRegistration.getClientAuthenticationMethod())) {
            String clientId = this.encodeClientCredentialIfRequired(clientRegistration.getClientId());
            String clientSecret = this.encodeClientCredentialIfRequired(clientRegistration.getClientSecret());
            headers.setBasicAuth(clientId, clientSecret);
        }
        return headers;
    }

    private String encodeClientCredentialIfRequired(String clientCredential) {
        if (!this.encodeClientCredentials) {
            return clientCredential;
        }
        return URLEncoder.encode(clientCredential, StandardCharsets.UTF_8);
    }

    public void setEncodeClientCredentials(boolean encodeClientCredentials) {
        this.encodeClientCredentials = encodeClientCredentials;
    }
}

