/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.kafka.test.EmbeddedKafkaBroker;
import org.springframework.kafka.test.EmbeddedKafkaKraftBroker;
import org.springframework.kafka.test.EmbeddedKafkaZKBroker;
import org.springframework.kafka.test.context.EmbeddedKafka;
import org.springframework.util.StringUtils;

public final class EmbeddedKafkaBrokerFactory {
    private static final String TRANSACTION_STATE_LOG_REPLICATION_FACTOR = "transaction.state.log.replication.factor";

    public static EmbeddedKafkaBroker create(EmbeddedKafka embeddedKafka) {
        return EmbeddedKafkaBrokerFactory.create(embeddedKafka, Function.identity());
    }

    public static EmbeddedKafkaBroker create(EmbeddedKafka embeddedKafka, Function<String, String> propertyResolver) {
        String[] topics = (String[])Arrays.stream(embeddedKafka.topics()).map(propertyResolver).toArray(String[]::new);
        EmbeddedKafkaBroker embeddedKafkaBroker = embeddedKafka.kraft() ? EmbeddedKafkaBrokerFactory.kraftBroker(embeddedKafka, topics) : EmbeddedKafkaBrokerFactory.zkBroker(embeddedKafka, topics);
        int[] ports = EmbeddedKafkaBrokerFactory.setupPorts(embeddedKafka);
        embeddedKafkaBroker.kafkaPorts(ports).adminTimeout(embeddedKafka.adminTimeout());
        Properties properties = new Properties();
        for (String pair : embeddedKafka.brokerProperties()) {
            if (!StringUtils.hasText((String)pair)) continue;
            try {
                properties.load(new StringReader(propertyResolver.apply(pair)));
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to load broker property from [" + pair + "]", ex);
            }
        }
        String brokerPropertiesLocation = embeddedKafka.brokerPropertiesLocation();
        if (StringUtils.hasText((String)brokerPropertiesLocation)) {
            String propertiesLocation = propertyResolver.apply(brokerPropertiesLocation);
            Resource propertiesResource = new PathMatchingResourcePatternResolver().getResource(propertiesLocation);
            if (!propertiesResource.exists()) {
                throw new IllegalStateException("Failed to load broker properties from [" + propertiesResource + "]: resource does not exist.");
            }
            try (InputStream in = propertiesResource.getInputStream();){
                Properties p = new Properties();
                p.load(in);
                p.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> properties.putIfAbsent(key, propertyResolver.apply((String)value))));
            }
            catch (IOException ex) {
                throw new IllegalStateException("Failed to load broker properties from [" + propertiesResource + "]", ex);
            }
        }
        properties.putIfAbsent(TRANSACTION_STATE_LOG_REPLICATION_FACTOR, String.valueOf(Math.min(3, embeddedKafka.count())));
        embeddedKafkaBroker.brokerProperties(properties);
        String bootstrapServersProperty = embeddedKafka.bootstrapServersProperty();
        if (StringUtils.hasText((String)bootstrapServersProperty)) {
            embeddedKafkaBroker.brokerListProperty(bootstrapServersProperty);
        }
        embeddedKafkaBroker.afterPropertiesSet();
        return embeddedKafkaBroker;
    }

    private static int[] setupPorts(EmbeddedKafka embedded) {
        int[] ports = embedded.ports();
        if (embedded.count() > 1 && ports.length == 1 && ports[0] == 0) {
            ports = new int[embedded.count()];
        }
        return ports;
    }

    private static EmbeddedKafkaBroker kraftBroker(EmbeddedKafka embedded, String[] topics) {
        return new EmbeddedKafkaKraftBroker(embedded.count(), embedded.partitions(), topics);
    }

    private static EmbeddedKafkaBroker zkBroker(EmbeddedKafka embedded, String[] topics) {
        return new EmbeddedKafkaZKBroker(embedded.count(), embedded.controlledShutdown(), embedded.partitions(), topics).zkPort(embedded.zookeeperPort()).zkConnectionTimeout(embedded.zkConnectionTimeout()).zkSessionTimeout(embedded.zkSessionTimeout());
    }

    private EmbeddedKafkaBrokerFactory() {
    }
}

