/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.UriTemplate;
import org.springframework.hateoas.mediatype.hal.CurieProvider;
import org.springframework.hateoas.mediatype.hal.HalLinkRelation;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

public class DefaultCurieProvider
implements CurieProvider {
    private final Map<String, UriTemplate> curies;
    private final String defaultCurie;

    public DefaultCurieProvider(String name, UriTemplate uriTemplate) {
        this(Collections.singletonMap(name, uriTemplate));
    }

    public DefaultCurieProvider(Map<String, UriTemplate> curies) {
        this(curies, null);
    }

    public DefaultCurieProvider(Map<String, UriTemplate> curies, @Nullable String defaultCurieName) {
        Assert.notNull(curies, (String)"Curies must not be null!");
        curies.forEach((name, template) -> {
            Assert.hasText((String)name, (String)"Curie name must not be null or empty!");
            Assert.notNull((Object)template, (String)"UriTemplate must not be null!");
            Assert.isTrue((template.getVariableNames().size() == 1 ? 1 : 0) != 0, (String)String.format("Expected a single template variable in the UriTemplate %s!", template.toString()));
        });
        this.defaultCurie = StringUtils.hasText((String)defaultCurieName) ? defaultCurieName : (curies.size() == 1 ? curies.keySet().iterator().next() : null);
        this.curies = Collections.unmodifiableMap(curies);
    }

    @Override
    public Collection<?> getCurieInformation(Links links) {
        return this.curies.entrySet().stream().map(it -> new Curie((String)it.getKey(), this.getCurieHref((String)it.getKey(), (UriTemplate)it.getValue()))).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableCollection));
    }

    @Override
    public HalLinkRelation getNamespacedRelFrom(Link link) {
        return this.getNamespacedRelFor(link.getRel());
    }

    @Override
    public HalLinkRelation getNamespacedRelFor(LinkRelation relation) {
        HalLinkRelation result = HalLinkRelation.of(relation);
        return this.defaultCurie == null ? result : result.curieIfUncuried(this.defaultCurie);
    }

    protected String getCurieHref(String name, UriTemplate template) {
        if (template.toString().startsWith("http")) {
            return template.toString();
        }
        String applicationUri = ServletUriComponentsBuilder.fromCurrentServletMapping().build().expand(new Object[0]).toString();
        return applicationUri.concat(template.toString());
    }

    protected static class Curie
    extends Link {
        private static final long serialVersionUID = 1L;
        private final String name;

        public Curie(String name, String href) {
            super(href, LinkRelation.of("curies"));
            this.name = name;
        }

        @Override
        @NonNull
        public String getName() {
            return this.name;
        }
    }
}

