/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.test;

import java.lang.reflect.Method;
import java.util.Collection;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;
import org.springframework.cloud.test.ModifiedClassPathClassLoader;
import org.springframework.util.CollectionUtils;

class ModifiedClassPathExtension
implements InvocationInterceptor {
    ModifiedClassPathExtension() {
    }

    public void interceptBeforeAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.intercept(invocation, extensionContext);
    }

    public void interceptBeforeEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.intercept(invocation, extensionContext);
    }

    public void interceptAfterEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.intercept(invocation, extensionContext);
    }

    public void interceptAfterAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.intercept(invocation, extensionContext);
    }

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.interceptMethod(invocation, invocationContext, extensionContext);
    }

    public void interceptTestTemplateMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.interceptMethod(invocation, invocationContext, extensionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interceptMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        Method testMethod;
        if (this.isModifiedClassPathClassLoader(extensionContext)) {
            invocation.proceed();
            return;
        }
        Class testClass = extensionContext.getRequiredTestClass();
        ModifiedClassPathClassLoader modifiedClassLoader = ModifiedClassPathClassLoader.get(testClass, testMethod = (Method)invocationContext.getExecutable(), invocationContext.getArguments());
        if (modifiedClassLoader == null) {
            invocation.proceed();
            return;
        }
        invocation.skip();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(modifiedClassLoader);
        try {
            this.runTest(extensionContext.getUniqueId());
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private void runTest(String testId) throws Throwable {
        LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request().selectors(new DiscoverySelector[]{DiscoverySelectors.selectUniqueId((String)testId)}).build();
        Launcher launcher = LauncherFactory.create();
        TestPlan testPlan = launcher.discover(request);
        SummaryGeneratingListener listener = new SummaryGeneratingListener();
        launcher.registerTestExecutionListeners(new TestExecutionListener[]{listener});
        launcher.execute(testPlan, new TestExecutionListener[0]);
        TestExecutionSummary summary = listener.getSummary();
        if (!CollectionUtils.isEmpty((Collection)summary.getFailures())) {
            throw ((TestExecutionSummary.Failure)summary.getFailures().get(0)).getException();
        }
    }

    private void intercept(InvocationInterceptor.Invocation<Void> invocation, ExtensionContext extensionContext) throws Throwable {
        if (this.isModifiedClassPathClassLoader(extensionContext)) {
            invocation.proceed();
            return;
        }
        invocation.skip();
    }

    private boolean isModifiedClassPathClassLoader(ExtensionContext extensionContext) {
        Class testClass = extensionContext.getRequiredTestClass();
        ClassLoader classLoader = testClass.getClassLoader();
        return classLoader.getClass().getName().equals(ModifiedClassPathClassLoader.class.getName());
    }
}

