/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.service.relational;

import java.util.logging.Logger;
import javax.sql.DataSource;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.cloud.service.PooledServiceConnectorConfig;
import org.springframework.cloud.service.ServiceConnectorConfig;
import org.springframework.cloud.service.common.RelationalServiceInfo;
import org.springframework.cloud.service.relational.DataSourceConfig;
import org.springframework.cloud.service.relational.DataSourceConfigurer;
import org.springframework.cloud.service.relational.PooledDataSourceCreator;

public abstract class DbcpLikePooledDataSourceCreator<SI extends RelationalServiceInfo>
implements PooledDataSourceCreator<SI> {
    protected static Logger logger = Logger.getLogger(PooledDataSourceCreator.class.getName());
    private DataSourceConfigurer configurer = new DataSourceConfigurer();

    protected void setBasicDataSourceProperties(DataSource basicDataSource, RelationalServiceInfo serviceInfo, ServiceConnectorConfig serviceConnectorConfig, String driverClassName, String validationQuery) {
        BeanWrapperImpl target = new BeanWrapperImpl((Object)basicDataSource);
        target.setPropertyValue("driverClassName", (Object)driverClassName);
        target.setPropertyValue("url", (Object)serviceInfo.getJdbcUrl());
        if (validationQuery != null) {
            target.setPropertyValue("validationQuery", (Object)validationQuery);
            target.setPropertyValue("testOnBorrow", (Object)true);
        }
        if (serviceConnectorConfig == null) {
            serviceConnectorConfig = new DataSourceConfig(new PooledServiceConnectorConfig.PoolConfig(4, 30000), null);
        }
        this.configurer.configure(basicDataSource, (DataSourceConfig)serviceConnectorConfig);
    }
}

