/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.instrument.jdbc;

import com.p6spy.engine.logging.P6LogFactory;
import com.p6spy.engine.spy.P6ModuleManager;
import com.p6spy.engine.spy.P6SpyFactory;
import com.p6spy.engine.spy.option.EnvironmentVariables;
import com.p6spy.engine.spy.option.P6OptionsSource;
import com.p6spy.engine.spy.option.SpyDotProperties;
import com.p6spy.engine.spy.option.SystemProperties;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.cloud.sleuth.autoconfig.instrument.jdbc.TraceJdbcProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

class P6SpyPropertiesSetter
implements BeanDefinitionRegistryPostProcessor,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(P6SpyPropertiesSetter.class);
    private final ConfigurableApplicationContext context;
    private final Map<String, String> initialP6SpyOptions;

    P6SpyPropertiesSetter(ConfigurableApplicationContext context) {
        this.context = context;
        this.initialP6SpyOptions = this.findDefinedOptions();
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String pattern;
        ConfigurableEnvironment environment = this.context.getEnvironment();
        String customModuleList = this.initialP6SpyOptions.get("modulelist");
        boolean isEnableLogging = (Boolean)environment.getProperty("spring.sleuth.jdbc.p6spy.enable-logging", Boolean.class, (Object)false);
        if (customModuleList != null) {
            log.info("P6Spy modulelist is overridden, some p6spy configuration features will not be applied");
        } else {
            ArrayList<String> moduleList = new ArrayList<String>();
            moduleList.add(P6SpyFactory.class.getName());
            if (isEnableLogging) {
                moduleList.add(P6LogFactory.class.getName());
            }
            System.setProperty("p6spy.config.modulelist", String.join((CharSequence)",", moduleList));
        }
        if (!this.initialP6SpyOptions.containsKey("logMessageFormat")) {
            String logFormat = this.logFormat(environment);
            boolean isMultiline = this.multiLine(environment);
            if (logFormat != null) {
                System.setProperty("p6spy.config.logMessageFormat", "com.p6spy.engine.spy.appender.CustomLineFormat");
                System.setProperty("p6spy.config.customLogMessageFormat", logFormat);
            } else if (isMultiline) {
                System.setProperty("p6spy.config.logMessageFormat", "com.p6spy.engine.spy.appender.MultiLineFormat");
            }
        }
        if (isEnableLogging && !this.initialP6SpyOptions.containsKey("appender")) {
            TraceJdbcProperties.P6SpyProperties.P6SpyLogging logging = TraceJdbcProperties.P6SpyProperties.P6SpyLogging.valueOf(((String)environment.getProperty("spring.sleuth.jdbc.p6spy.logging", String.class, (Object)TraceJdbcProperties.P6SpyProperties.P6SpyLogging.SLF4J.toString())).toUpperCase());
            switch (logging) {
                case SYSOUT: {
                    System.setProperty("p6spy.config.appender", "com.p6spy.engine.spy.appender.StdoutLogger");
                    break;
                }
                case SLF4J: {
                    System.setProperty("p6spy.config.appender", "com.p6spy.engine.spy.appender.Slf4JLogger");
                    break;
                }
                case FILE: {
                    System.setProperty("p6spy.config.appender", "com.p6spy.engine.spy.appender.FileLogger");
                    break;
                }
                case CUSTOM: {
                    String customAppender = (String)environment.getProperty("spring.sleuth.jdbc.p6spy.custom-appender-class", String.class, (Object)"");
                    System.setProperty("p6spy.config.appender", customAppender);
                }
            }
        }
        if (!this.initialP6SpyOptions.containsKey("logfile")) {
            String logFile = (String)environment.getProperty("spring.sleuth.jdbc.p6spy.log-file", String.class, (Object)"spy.log");
            System.setProperty("p6spy.config.logfile", logFile);
        }
        if ((pattern = (String)environment.getProperty("spring.sleuth.jdbc.p6spy.log-filter.pattern", String.class)) != null) {
            System.setProperty("p6spy.config.filter", "true");
            System.setProperty("p6spy.config.sqlexpression", pattern);
        }
        P6ModuleManager.getInstance().reload();
    }

    private Boolean multiLine(ConfigurableEnvironment environment) {
        return (Boolean)environment.getProperty("spring.sleuth.jdbc.p6spy.multiline", Boolean.class, (Object)true);
    }

    private String logFormat(ConfigurableEnvironment environment) {
        return (String)environment.getProperty("spring.sleuth.jdbc.p6spy.log-format", String.class);
    }

    @Override
    public void close() throws IOException {
        if (!this.initialP6SpyOptions.containsKey("modulelist")) {
            System.clearProperty("p6spy.config.modulelist");
        }
        if (!this.initialP6SpyOptions.containsKey("logMessageFormat")) {
            ConfigurableEnvironment environment = this.context.getEnvironment();
            String logFormat = this.logFormat(environment);
            boolean isMultiline = this.multiLine(environment);
            if (logFormat != null) {
                System.clearProperty("p6spy.config.logMessageFormat");
                System.clearProperty("p6spy.config.customLogMessageFormat");
            } else if (isMultiline) {
                System.clearProperty("p6spy.config.logMessageFormat");
            }
        }
        if (!this.initialP6SpyOptions.containsKey("appender")) {
            System.clearProperty("p6spy.config.appender");
        }
        if (!this.initialP6SpyOptions.containsKey("logfile")) {
            System.clearProperty("p6spy.config.logfile");
        }
        P6ModuleManager.getInstance().reload();
    }

    private Map<String, String> findDefinedOptions() {
        SpyDotProperties spyDotProperties = null;
        try {
            spyDotProperties = new SpyDotProperties();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Stream.of(spyDotProperties, new EnvironmentVariables(), new SystemProperties()).filter(Objects::nonNull).map(P6OptionsSource::getOptions).filter(Objects::nonNull).flatMap(options -> options.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (value1, value2) -> value1));
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
    }
}

