/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.brave;

import brave.Tracing;
import brave.handler.SpanHandler;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.SpanCustomizer;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.autoconfig.SleuthBaggageProperties;
import org.springframework.cloud.sleuth.autoconfig.brave.SleuthPropagationProperties;
import org.springframework.cloud.sleuth.brave.bridge.BraveBaggageManager;
import org.springframework.cloud.sleuth.brave.bridge.BraveContextWrappingFunction;
import org.springframework.cloud.sleuth.brave.bridge.BraveCurrentTraceContext;
import org.springframework.cloud.sleuth.brave.bridge.BravePropagator;
import org.springframework.cloud.sleuth.brave.bridge.BraveSpanCustomizer;
import org.springframework.cloud.sleuth.brave.bridge.BraveTracer;
import org.springframework.cloud.sleuth.brave.bridge.CompositePropagationFactorySupplier;
import org.springframework.cloud.sleuth.brave.bridge.CompositeSpanHandler;
import org.springframework.cloud.sleuth.brave.propagation.PropagationFactorySupplier;
import org.springframework.cloud.sleuth.exporter.SpanFilter;
import org.springframework.cloud.sleuth.exporter.SpanReporter;
import org.springframework.cloud.sleuth.instrument.reactor.ReactorSleuth;
import org.springframework.cloud.sleuth.propagation.Propagator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={SleuthPropagationProperties.class})
class BraveBridgeConfiguration {
    BraveBridgeConfiguration() {
    }

    @Bean
    Tracer braveTracer(brave.Tracer tracer, CurrentTraceContext braveCurrentTraceContext) {
        return new BraveTracer(tracer, braveCurrentTraceContext, new BraveBaggageManager());
    }

    @Bean
    CurrentTraceContext braveCurrentTraceContext(brave.propagation.CurrentTraceContext currentTraceContext) {
        return new BraveCurrentTraceContext(currentTraceContext);
    }

    @Bean
    SpanCustomizer braveSpanCustomizer(brave.SpanCustomizer spanCustomizer) {
        return new BraveSpanCustomizer(spanCustomizer);
    }

    @Bean
    Propagator bravePropagator(Tracing tracing) {
        return new BravePropagator(tracing);
    }

    @Bean
    @ConditionalOnMissingBean
    PropagationFactorySupplier compositePropagationFactorySupplier(BeanFactory beanFactory, SleuthBaggageProperties baggageProperties, SleuthPropagationProperties properties) {
        return new CompositePropagationFactorySupplier(beanFactory, baggageProperties.getLocalFields(), properties.getType());
    }

    @Bean(name={"traceCompositeSpanHandler"})
    SpanHandler compositeSpanHandler(ObjectProvider<List<SpanFilter>> exporters, ObjectProvider<List<SpanReporter>> reporters) {
        return new CompositeSpanHandler((List)exporters.getIfAvailable(ArrayList::new), (List)reporters.getIfAvailable(ArrayList::new));
    }

    @Bean
    @ConditionalOnClass(name={"reactor.util.context.Context"})
    static BraveReactorContextBeanDefinitionRegistryPostProcessor braveReactorContextBeanDefinitionRegistryPostProcessor() {
        return new BraveReactorContextBeanDefinitionRegistryPostProcessor();
    }

    static class BraveReactorContextBeanDefinitionRegistryPostProcessor
    implements BeanDefinitionRegistryPostProcessor,
    Closeable {
        private static final Log log = LogFactory.getLog(BraveReactorContextBeanDefinitionRegistryPostProcessor.class);

        BraveReactorContextBeanDefinitionRegistryPostProcessor() {
        }

        @Override
        public void close() throws IOException {
            ReactorSleuth.contextWrappingFunction = Function.identity();
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            ReactorSleuth.contextWrappingFunction = new BraveContextWrappingFunction();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Wrapped Reactor's context into a Brave representation");
            }
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }
    }
}

