/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.trace.sleuth;

import brave.SpanCustomizer;
import brave.http.HttpAdapter;
import brave.http.HttpClientParser;
import java.net.URI;

public class StackdriverHttpClientParser
extends HttpClientParser {
    protected <Req> String spanName(HttpAdapter<Req, ?> adapter, Req req) {
        URI uri = URI.create(adapter.url(req));
        return uri.toASCIIString();
    }

    public <Req> void request(HttpAdapter<Req, ?> adapter, Req req, SpanCustomizer customizer) {
        super.request(adapter, req, customizer);
        String url = adapter.url(req);
        URI uri = URI.create(url);
        customizer.tag("http.url", url);
        if (uri.getHost() != null) {
            customizer.tag("http.host", uri.getHost());
        }
        customizer.tag("http.path", uri.getPath());
        customizer.tag("http.method", adapter.method(req));
    }

    public <Resp> void response(HttpAdapter<?, Resp> adapter, Resp res, Throwable error, SpanCustomizer customizer) {
        int statusCode = 0;
        if (res != null) {
            String route = adapter.route(res);
            if (route != null) {
                customizer.tag("http.route", route);
            }
            statusCode = adapter.statusCodeAsInt(res);
            customizer.tag("http.status_code", String.valueOf(statusCode));
        }
        this.error(statusCode, error, customizer);
    }
}

