/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.source;

import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.boot.context.properties.source.ConfigurationPropertySourcesPropertySource;
import org.springframework.boot.context.properties.source.InvalidConfigurationPropertyValueException;
import org.springframework.boot.context.properties.source.SpringConfigurationPropertySources;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.env.AbstractPropertyResolver;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.PropertySourcesPropertyResolver;

class ConfigurationPropertySourcesPropertyResolver
extends AbstractPropertyResolver {
    private final MutablePropertySources propertySources;
    private final DefaultResolver defaultResolver;

    ConfigurationPropertySourcesPropertyResolver(MutablePropertySources propertySources) {
        this.propertySources = propertySources;
        this.defaultResolver = new DefaultResolver((PropertySources)propertySources);
    }

    public boolean containsProperty(String key) {
        ConfigurationPropertyName name;
        ConfigurationPropertySourcesPropertySource attached = this.getAttached();
        if (attached != null && (name = ConfigurationPropertyName.of(key, true)) != null) {
            try {
                return attached.findConfigurationProperty(name) != null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.defaultResolver.containsProperty(key);
    }

    public String getProperty(String key) {
        return this.getProperty(key, String.class, true);
    }

    public <T> T getProperty(String key, Class<T> targetValueType) {
        return this.getProperty(key, targetValueType, true);
    }

    protected String getPropertyAsRawString(String key) {
        return this.getProperty(key, String.class, false);
    }

    private <T> T getProperty(String key, Class<T> targetValueType, boolean resolveNestedPlaceholders) {
        Object value = this.findPropertyValue(key);
        if (value == null) {
            return null;
        }
        if (resolveNestedPlaceholders && value instanceof String) {
            String string = (String)value;
            value = this.resolveNestedPlaceholders(string);
        }
        try {
            return (T)this.convertValueIfNecessary(value, targetValueType);
        }
        catch (ConversionFailedException ex) {
            InvalidConfigurationPropertyValueException wrappedCause = new InvalidConfigurationPropertyValueException(key, value, "Failed to convert to type " + ex.getTargetType(), ex.getCause());
            throw new ConversionFailedException(ex.getSourceType(), ex.getTargetType(), ex.getValue(), (Throwable)wrappedCause);
        }
    }

    private Object findPropertyValue(String key) {
        ConfigurationPropertyName name;
        ConfigurationPropertySourcesPropertySource attached = this.getAttached();
        if (attached != null && (name = ConfigurationPropertyName.of(key, true)) != null) {
            try {
                ConfigurationProperty configurationProperty = attached.findConfigurationProperty(name);
                return configurationProperty != null ? configurationProperty.getValue() : null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.defaultResolver.getProperty(key, Object.class, false);
    }

    private ConfigurationPropertySourcesPropertySource getAttached() {
        SpringConfigurationPropertySources springSource;
        Iterable attachedSource;
        ConfigurationPropertySourcesPropertySource attached = (ConfigurationPropertySourcesPropertySource)ConfigurationPropertySources.getAttached(this.propertySources);
        Iterable iterable = attachedSource = attached != null ? (Iterable)attached.getSource() : null;
        if (attachedSource instanceof SpringConfigurationPropertySources && (springSource = (SpringConfigurationPropertySources)attachedSource).isUsingSources((Iterable<PropertySource<?>>)this.propertySources)) {
            return attached;
        }
        return null;
    }

    static class DefaultResolver
    extends PropertySourcesPropertyResolver {
        DefaultResolver(PropertySources propertySources) {
            super(propertySources);
        }

        public <T> T getProperty(String key, Class<T> targetValueType, boolean resolveNestedPlaceholders) {
            return (T)super.getProperty(key, targetValueType, resolveNestedPlaceholders);
        }
    }
}

