/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jackson.autoconfigure;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jackson.JacksonComponentModule;
import org.springframework.boot.jackson.JacksonMixinModule;
import org.springframework.boot.jackson.JacksonMixinModuleEntries;
import org.springframework.boot.jackson.autoconfigure.CborMapperBuilderCustomizer;
import org.springframework.boot.jackson.autoconfigure.JacksonCborProperties;
import org.springframework.boot.jackson.autoconfigure.JacksonProperties;
import org.springframework.boot.jackson.autoconfigure.JacksonXmlProperties;
import org.springframework.boot.jackson.autoconfigure.JsonMapperBuilderCustomizer;
import org.springframework.boot.jackson.autoconfigure.XmlMapperBuilderCustomizer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.core.Ordered;
import org.springframework.http.ProblemDetail;
import org.springframework.http.converter.json.ProblemDetailJacksonMixin;
import org.springframework.http.converter.json.ProblemDetailJacksonXmlMixin;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.PropertyNamingStrategies;
import tools.jackson.databind.PropertyNamingStrategy;
import tools.jackson.databind.cfg.ConstructorDetector;
import tools.jackson.databind.cfg.DatatypeFeature;
import tools.jackson.databind.cfg.DateTimeFeature;
import tools.jackson.databind.cfg.MapperBuilder;
import tools.jackson.databind.json.JsonMapper;
import tools.jackson.dataformat.cbor.CBORMapper;
import tools.jackson.dataformat.xml.XmlMapper;

@AutoConfiguration
@ConditionalOnClass(value={JsonMapper.class})
public final class JacksonAutoConfiguration {
    @Bean
    JacksonComponentModule jsonComponentModule() {
        return new JacksonComponentModule();
    }

    @Bean
    @Scope(value="prototype")
    @ConditionalOnMissingBean
    JsonMapper.Builder jsonMapperBuilder(List<JsonMapperBuilderCustomizer> customizers) {
        JsonMapper.Builder builder = JsonMapper.builder();
        this.customize(builder, customizers);
        return builder;
    }

    private void customize(JsonMapper.Builder builder, List<JsonMapperBuilderCustomizer> customizers) {
        for (JsonMapperBuilderCustomizer customizer : customizers) {
            customizer.customize(builder);
        }
    }

    @Bean
    @Primary
    @ConditionalOnMissingBean
    JsonMapper jacksonJsonMapper(JsonMapper.Builder builder) {
        return builder.build();
    }

    static abstract class AbstractMapperBuilderCustomizer<B extends MapperBuilder<?, ?>>
    implements Ordered {
        private final JacksonProperties jacksonProperties;
        private final Collection<JacksonModule> modules;

        AbstractMapperBuilderCustomizer(JacksonProperties jacksonProperties, Collection<JacksonModule> modules) {
            this.jacksonProperties = jacksonProperties;
            this.modules = modules;
        }

        public int getOrder() {
            return 0;
        }

        protected JacksonProperties properties() {
            return this.jacksonProperties;
        }

        protected void customize(B builder) {
            JsonInclude.Include propertyInclusion;
            if (this.jacksonProperties.isUseJackson2Defaults()) {
                builder.configureForJackson2().disable(new DatatypeFeature[]{DateTimeFeature.WRITE_DATES_AS_TIMESTAMPS, DateTimeFeature.WRITE_DURATIONS_AS_TIMESTAMPS});
            }
            if (this.jacksonProperties.isFindAndAddModules()) {
                builder.findAndAddModules(this.getClass().getClassLoader());
            }
            if ((propertyInclusion = this.jacksonProperties.getDefaultPropertyInclusion()) != null) {
                builder.changeDefaultPropertyInclusion(handler -> handler.withValueInclusion(propertyInclusion).withContentInclusion(propertyInclusion));
            }
            if (this.jacksonProperties.getTimeZone() != null) {
                builder.defaultTimeZone(this.jacksonProperties.getTimeZone());
            }
            this.configureVisibility((MapperBuilder<?, ?>)builder, this.jacksonProperties.getVisibility());
            this.configureFeatures(builder, this.jacksonProperties.getDeserialization(), (arg_0, arg_1) -> builder.configure(arg_0, arg_1));
            this.configureFeatures(builder, this.jacksonProperties.getSerialization(), (arg_0, arg_1) -> builder.configure(arg_0, arg_1));
            this.configureFeatures(builder, this.jacksonProperties.getMapper(), (arg_0, arg_1) -> builder.configure(arg_0, arg_1));
            this.configureFeatures(builder, this.jacksonProperties.getDatatype().getDatetime(), (arg_0, arg_1) -> builder.configure(arg_0, arg_1));
            this.configureFeatures(builder, this.jacksonProperties.getDatatype().getEnum(), (arg_0, arg_1) -> builder.configure(arg_0, arg_1));
            this.configureFeatures(builder, this.jacksonProperties.getDatatype().getJsonNode(), (arg_0, arg_1) -> builder.configure(arg_0, arg_1));
            this.configureDateFormat((MapperBuilder<?, ?>)builder);
            this.configurePropertyNamingStrategy((MapperBuilder<?, ?>)builder);
            this.configureModules((MapperBuilder<?, ?>)builder);
            this.configureLocale((MapperBuilder<?, ?>)builder);
            this.configureDefaultLeniency((MapperBuilder<?, ?>)builder);
            this.configureConstructorDetector((MapperBuilder<?, ?>)builder);
        }

        protected <T> void configureFeatures(B builder, Map<T, Boolean> features, BiConsumer<T, Boolean> configure) {
            features.forEach((feature, value) -> {
                if (value != null) {
                    configure.accept((Object)feature, (Boolean)value);
                }
            });
        }

        private void configureVisibility(MapperBuilder<?, ?> builder, Map<PropertyAccessor, JsonAutoDetect.Visibility> visibilities) {
            builder.changeDefaultVisibility(visibilityChecker -> {
                for (Map.Entry entry : visibilities.entrySet()) {
                    visibilityChecker = visibilityChecker.withVisibility((PropertyAccessor)entry.getKey(), (JsonAutoDetect.Visibility)entry.getValue());
                }
                return visibilityChecker;
            });
        }

        private void configureDateFormat(MapperBuilder<?, ?> builder) {
            String dateFormat = this.jacksonProperties.getDateFormat();
            if (dateFormat != null) {
                try {
                    Class dateFormatClass = ClassUtils.forName((String)dateFormat, null);
                    builder.defaultDateFormat((DateFormat)BeanUtils.instantiateClass((Class)dateFormatClass));
                }
                catch (ClassNotFoundException ex) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
                    TimeZone timeZone = this.jacksonProperties.getTimeZone();
                    if (timeZone == null) {
                        timeZone = new ObjectMapper().serializationConfig().getTimeZone();
                    }
                    simpleDateFormat.setTimeZone(timeZone);
                    builder.defaultDateFormat((DateFormat)simpleDateFormat);
                }
            }
        }

        private void configurePropertyNamingStrategy(MapperBuilder<?, ?> builder) {
            String strategy = this.jacksonProperties.getPropertyNamingStrategy();
            if (strategy != null) {
                try {
                    this.configurePropertyNamingStrategyClass(builder, ClassUtils.forName((String)strategy, null));
                }
                catch (ClassNotFoundException ex) {
                    this.configurePropertyNamingStrategyField(builder, strategy);
                }
            }
        }

        private void configurePropertyNamingStrategyClass(MapperBuilder<?, ?> builder, Class<?> propertyNamingStrategyClass) {
            builder.propertyNamingStrategy((PropertyNamingStrategy)BeanUtils.instantiateClass(propertyNamingStrategyClass));
        }

        private void configurePropertyNamingStrategyField(MapperBuilder<?, ?> builder, String fieldName) {
            Field field = this.findPropertyNamingStrategyField(fieldName);
            try {
                builder.propertyNamingStrategy((PropertyNamingStrategy)field.get(null));
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
        }

        private Field findPropertyNamingStrategyField(String fieldName) {
            Field field = ReflectionUtils.findField(PropertyNamingStrategies.class, (String)fieldName, PropertyNamingStrategy.class);
            Assert.state((field != null ? 1 : 0) != 0, () -> "Constant named '" + fieldName + "' not found");
            return field;
        }

        private void configureModules(MapperBuilder<?, ?> builder) {
            builder.addModules(this.modules);
        }

        private void configureLocale(MapperBuilder<?, ?> builder) {
            Locale locale = this.jacksonProperties.getLocale();
            if (locale != null) {
                builder.defaultLocale(locale);
            }
        }

        private void configureDefaultLeniency(MapperBuilder<?, ?> builder) {
            Boolean defaultLeniency = this.jacksonProperties.getDefaultLeniency();
            if (defaultLeniency != null) {
                builder.defaultLeniency(defaultLeniency);
            }
        }

        private void configureConstructorDetector(MapperBuilder<?, ?> builder) {
            JacksonProperties.ConstructorDetectorStrategy strategy = this.jacksonProperties.getConstructorDetector();
            if (strategy != null) {
                switch (strategy) {
                    case USE_PROPERTIES_BASED: {
                        builder.constructorDetector(ConstructorDetector.USE_PROPERTIES_BASED);
                        break;
                    }
                    case USE_DELEGATING: {
                        builder.constructorDetector(ConstructorDetector.USE_DELEGATING);
                        break;
                    }
                    case EXPLICIT_ONLY: {
                        builder.constructorDetector(ConstructorDetector.EXPLICIT_ONLY);
                        break;
                    }
                    default: {
                        builder.constructorDetector(ConstructorDetector.DEFAULT);
                    }
                }
            }
        }
    }

    static class JacksonAutoConfigurationRuntimeHints
    implements RuntimeHintsRegistrar {
        JacksonAutoConfigurationRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
            if (ClassUtils.isPresent((String)"tools.jackson.databind.PropertyNamingStrategy", (ClassLoader)classLoader)) {
                this.registerPropertyNamingStrategyHints(hints.reflection());
            }
        }

        private void registerPropertyNamingStrategyHints(ReflectionHints hints) {
            this.registerPropertyNamingStrategyHints(hints, PropertyNamingStrategies.class);
        }

        private void registerPropertyNamingStrategyHints(ReflectionHints hints, Class<?> type) {
            Stream.of(type.getDeclaredFields()).filter(this::isPropertyNamingStrategyField).forEach(arg_0 -> ((ReflectionHints)hints).registerField(arg_0));
        }

        private boolean isPropertyNamingStrategyField(Field candidate) {
            return ReflectionUtils.isPublicStaticFinal((Field)candidate) && candidate.getType().isAssignableFrom(PropertyNamingStrategy.class);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={XmlMapper.class})
    @EnableConfigurationProperties(value={JacksonXmlProperties.class})
    static class XmlConfiguration {
        XmlConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        XmlMapper xmlMapper(XmlMapper.Builder builder) {
            return builder.build();
        }

        @Bean
        @Scope(value="prototype")
        @ConditionalOnMissingBean
        XmlMapper.Builder xmlMapperBuilder(List<XmlMapperBuilderCustomizer> customizers) {
            XmlMapper.Builder builder = XmlMapper.builder();
            this.customize(builder, customizers);
            return builder;
        }

        private void customize(XmlMapper.Builder builder, List<XmlMapperBuilderCustomizer> customizers) {
            for (XmlMapperBuilderCustomizer customizer : customizers) {
                customizer.customize(builder);
            }
        }

        @Bean
        StandardXmlMapperBuilderCustomizer standardXmlMapperBuilderCustomizer(JacksonProperties jacksonProperties, ObjectProvider<JacksonModule> modules, JacksonXmlProperties xmlProperties) {
            return new StandardXmlMapperBuilderCustomizer(jacksonProperties, modules.stream().toList(), xmlProperties);
        }

        static class StandardXmlMapperBuilderCustomizer
        extends AbstractMapperBuilderCustomizer<XmlMapper.Builder>
        implements XmlMapperBuilderCustomizer {
            private final JacksonXmlProperties xmlProperties;

            StandardXmlMapperBuilderCustomizer(JacksonProperties jacksonProperties, Collection<JacksonModule> modules, JacksonXmlProperties xmlProperties) {
                super(jacksonProperties, modules);
                this.xmlProperties = xmlProperties;
            }

            @Override
            public void customize(XmlMapper.Builder builder) {
                super.customize(builder);
                this.configureFeatures(builder, this.xmlProperties.getRead(), (arg_0, arg_1) -> ((XmlMapper.Builder)builder).configure(arg_0, arg_1));
                this.configureFeatures(builder, this.xmlProperties.getWrite(), (arg_0, arg_1) -> ((XmlMapper.Builder)builder).configure(arg_0, arg_1));
            }
        }

        @Configuration(proxyBeanMethods=false)
        @ConditionalOnClass(value={ProblemDetail.class})
        static class XmlProblemDetailsConfiguration {
            XmlProblemDetailsConfiguration() {
            }

            @Bean
            ProblemDetailXmlMapperBuilderCustomizer problemDetailXmlMapperBuilderCustomizer() {
                return new ProblemDetailXmlMapperBuilderCustomizer();
            }

            static final class ProblemDetailXmlMapperBuilderCustomizer
            implements XmlMapperBuilderCustomizer {
                ProblemDetailXmlMapperBuilderCustomizer() {
                }

                @Override
                public void customize(XmlMapper.Builder builder) {
                    builder.addMixIn(ProblemDetail.class, ProblemDetailJacksonXmlMixin.class);
                }
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={CBORMapper.class})
    @EnableConfigurationProperties(value={JacksonCborProperties.class})
    static class CborConfiguration {
        CborConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        CBORMapper cborMapper(CBORMapper.Builder builder) {
            return builder.build();
        }

        @Bean
        @Scope(value="prototype")
        @ConditionalOnMissingBean
        CBORMapper.Builder cborMapperBuilder(List<CborMapperBuilderCustomizer> customizers) {
            CBORMapper.Builder builder = CBORMapper.builder();
            this.customize(builder, customizers);
            return builder;
        }

        private void customize(CBORMapper.Builder builder, List<CborMapperBuilderCustomizer> customizers) {
            for (CborMapperBuilderCustomizer customizer : customizers) {
                customizer.customize(builder);
            }
        }

        @Bean
        StandardCborMapperBuilderCustomizer standardCborMapperBuilderCustomizer(JacksonProperties jacksonProperties, ObjectProvider<JacksonModule> modules, JacksonCborProperties cborProperties) {
            return new StandardCborMapperBuilderCustomizer(jacksonProperties, modules.stream().toList(), cborProperties);
        }

        static class StandardCborMapperBuilderCustomizer
        extends AbstractMapperBuilderCustomizer<CBORMapper.Builder>
        implements CborMapperBuilderCustomizer {
            private final JacksonCborProperties cborProperties;

            StandardCborMapperBuilderCustomizer(JacksonProperties jacksonProperties, Collection<JacksonModule> modules, JacksonCborProperties cborProperties) {
                super(jacksonProperties, modules);
                this.cborProperties = cborProperties;
            }

            @Override
            public void customize(CBORMapper.Builder builder) {
                super.customize(builder);
                this.configureFeatures(builder, this.cborProperties.getRead(), (arg_0, arg_1) -> ((CBORMapper.Builder)builder).configure(arg_0, arg_1));
                this.configureFeatures(builder, this.cborProperties.getWrite(), (arg_0, arg_1) -> ((CBORMapper.Builder)builder).configure(arg_0, arg_1));
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ProblemDetail.class})
    static class JsonProblemDetailsConfiguration {
        JsonProblemDetailsConfiguration() {
        }

        @Bean
        ProblemDetailJsonMapperBuilderCustomizer problemDetailJsonMapperBuilderCustomizer() {
            return new ProblemDetailJsonMapperBuilderCustomizer();
        }

        static final class ProblemDetailJsonMapperBuilderCustomizer
        implements JsonMapperBuilderCustomizer {
            ProblemDetailJsonMapperBuilderCustomizer() {
            }

            @Override
            public void customize(JsonMapper.Builder builder) {
                builder.addMixIn(ProblemDetail.class, ProblemDetailJacksonMixin.class);
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @EnableConfigurationProperties(value={JacksonProperties.class})
    static class JacksonJsonMapperBuilderCustomizerConfiguration {
        JacksonJsonMapperBuilderCustomizerConfiguration() {
        }

        @Bean
        StandardJsonMapperBuilderCustomizer standardJsonMapperBuilderCustomizer(JacksonProperties jacksonProperties, ObjectProvider<JacksonModule> modules) {
            return new StandardJsonMapperBuilderCustomizer(jacksonProperties, modules.stream().toList());
        }

        static final class StandardJsonMapperBuilderCustomizer
        extends AbstractMapperBuilderCustomizer<JsonMapper.Builder>
        implements JsonMapperBuilderCustomizer {
            StandardJsonMapperBuilderCustomizer(JacksonProperties jacksonProperties, Collection<JacksonModule> modules) {
                super(jacksonProperties, modules);
            }

            @Override
            public void customize(JsonMapper.Builder builder) {
                super.customize(builder);
                this.configureFeatures(builder, this.properties().getJson().getRead(), (arg_0, arg_1) -> ((JsonMapper.Builder)builder).configure(arg_0, arg_1));
                this.configureFeatures(builder, this.properties().getJson().getWrite(), (arg_0, arg_1) -> ((JsonMapper.Builder)builder).configure(arg_0, arg_1));
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    static class JacksonMixinConfiguration {
        JacksonMixinConfiguration() {
        }

        @Bean
        static JacksonMixinModuleEntries jacksonMixinModuleEntries(ApplicationContext context) {
            List packages = AutoConfigurationPackages.has((BeanFactory)context) ? AutoConfigurationPackages.get((BeanFactory)context) : Collections.emptyList();
            return JacksonMixinModuleEntries.scan(context, packages);
        }

        @Bean
        JacksonMixinModule jacksonMixinModule(ApplicationContext context, JacksonMixinModuleEntries entries) {
            JacksonMixinModule jacksonMixinModule = new JacksonMixinModule();
            jacksonMixinModule.registerEntries(entries, context.getClassLoader());
            return jacksonMixinModule;
        }
    }
}

