/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client.reactive;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.http.client.HttpClientSettings;
import org.springframework.boot.http.client.ReactorHttpClientBuilder;
import org.springframework.boot.http.client.reactive.AbstractClientHttpConnectorBuilder;
import org.springframework.http.client.ReactorResourceFactory;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import reactor.netty.http.client.HttpClient;

public final class ReactorClientHttpConnectorBuilder
extends AbstractClientHttpConnectorBuilder<ReactorClientHttpConnector> {
    private final ReactorHttpClientBuilder httpClientBuilder;

    ReactorClientHttpConnectorBuilder() {
        this(null, new ReactorHttpClientBuilder());
    }

    private ReactorClientHttpConnectorBuilder(@Nullable List<Consumer<ReactorClientHttpConnector>> customizers, ReactorHttpClientBuilder httpClientBuilder) {
        super(customizers);
        this.httpClientBuilder = httpClientBuilder;
    }

    public ReactorClientHttpConnectorBuilder withCustomizer(Consumer<ReactorClientHttpConnector> customizer) {
        return new ReactorClientHttpConnectorBuilder(this.mergedCustomizers(customizer), this.httpClientBuilder);
    }

    public ReactorClientHttpConnectorBuilder withCustomizers(Collection<Consumer<ReactorClientHttpConnector>> customizers) {
        return new ReactorClientHttpConnectorBuilder(this.mergedCustomizers(customizers), this.httpClientBuilder);
    }

    public ReactorClientHttpConnectorBuilder withReactorResourceFactory(ReactorResourceFactory reactorResourceFactory) {
        Assert.notNull((Object)reactorResourceFactory, (String)"'reactorResourceFactory' must not be null");
        return new ReactorClientHttpConnectorBuilder(this.getCustomizers(), this.httpClientBuilder.withReactorResourceFactory(reactorResourceFactory));
    }

    public ReactorClientHttpConnectorBuilder withHttpClientFactory(Supplier<HttpClient> factory) {
        Assert.notNull(factory, (String)"'factory' must not be null");
        return new ReactorClientHttpConnectorBuilder(this.getCustomizers(), this.httpClientBuilder.withHttpClientFactory(factory));
    }

    public ReactorClientHttpConnectorBuilder withHttpClientCustomizer(UnaryOperator<HttpClient> httpClientCustomizer) {
        Assert.notNull(httpClientCustomizer, (String)"'httpClientCustomizer' must not be null");
        return new ReactorClientHttpConnectorBuilder(this.getCustomizers(), this.httpClientBuilder.withHttpClientCustomizer(httpClientCustomizer));
    }

    public ReactorClientHttpConnectorBuilder with(UnaryOperator<ReactorClientHttpConnectorBuilder> customizer) {
        return (ReactorClientHttpConnectorBuilder)customizer.apply(this);
    }

    @Override
    protected ReactorClientHttpConnector createClientHttpConnector(HttpClientSettings settings) {
        HttpClient httpClient = this.httpClientBuilder.build(settings);
        return new ReactorClientHttpConnector(httpClient);
    }

    static class Classes {
        static final String HTTP_CLIENT = "reactor.netty.http.client.HttpClient";

        Classes() {
        }

        static boolean present(@Nullable ClassLoader classLoader) {
            return ClassUtils.isPresent((String)HTTP_CLIENT, (ClassLoader)classLoader);
        }
    }
}

